/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicGridSize;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;

public abstract class LogicGate<G extends LogicGate<G, C>, C extends LogicConfig<C>>
extends LogicComponent<G, C> {
    private boolean outputState;

    protected static <G extends LogicGate<G, C>, C extends LogicConfig<C>> MapCodec<G> mapCodec(Codec<C> configCodec, Function3<C, Optional<DyeColor>, Boolean, G> function) {
        return RecordCodecBuilder.mapCodec((T instance) -> instance.group((App)configCodec.fieldOf("config").forGetter(LogicComponent::config), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.BOOL.optionalFieldOf("output", (Object)false).forGetter(LogicGate::output)).apply((Applicative)instance, function));
    }

    protected static <G extends LogicGate<G, C>, C extends LogicConfig<C>> MapCodec<G> mapCodec(BiFunction<Optional<DyeColor>, Boolean, G> creator) {
        return RecordCodecBuilder.mapCodec((T instance) -> instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.BOOL.optionalFieldOf("output", (Object)false).forGetter(LogicGate::output)).apply((Applicative)instance, creator));
    }

    protected static <G extends LogicGate<G, C>, C extends LogicConfig<C>> StreamCodec<ByteBuf, G> streamCodec(StreamCodec<ByteBuf, C> configCodec, Function3<C, Optional<DyeColor>, Boolean, G> function) {
        return StreamCodec.composite(configCodec, LogicComponent::config, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.BOOL, LogicGate::output, function);
    }

    protected static <G extends LogicGate<G, C>, C extends LogicConfig<C>> StreamCodec<ByteBuf, G> streamCodec(BiFunction<Optional<DyeColor>, Boolean, G> creator) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.BOOL, LogicGate::output, creator);
    }

    protected LogicGate(C config, Optional<DyeColor> color, boolean outputState) {
        super(config, color);
        this.outputState = outputState;
    }

    protected LogicGate(Optional<DyeColor> color, boolean outputState) {
        super(color);
        this.outputState = outputState;
    }

    protected abstract boolean processInputs(LogicContext var1, boolean[] var2);

    @Override
    public final void processTickInternal(LogicContext context, boolean[] inputs) {
        boolean originalOutputState = this.outputState;
        this.outputState = this.processInputs(context, inputs);
        if (this.outputState != originalOutputState) {
            context.markDirty(this);
        }
    }

    @Override
    protected final boolean outputInternal(int index) {
        return this.outputState;
    }

    public final boolean output() {
        return this.output(0);
    }

    @Override
    public LogicGridSize size() {
        int inputs = this.inputs();
        return new LogicGridSize(1, Math.max(1, inputs / 2));
    }

    @Override
    protected void internalLoadFrom(G other) {
        this.outputState = ((LogicGate)other).outputInternal(0);
    }

    @Override
    public void internalResetForPickup() {
        this.outputState = false;
    }
}

