/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.pulse;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.pulse.PulseThrottlerConfig;

public final class PulseThrottler
extends LogicComponent<PulseThrottler, PulseThrottlerConfig> {
    public static final MapCodec<PulseThrottler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PulseThrottlerConfig.CODEC.fieldOf("config").forGetter(LogicComponent::config), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.BOOL.optionalFieldOf("last_input", (Object)false).forGetter(PulseThrottler::lastInput), (App)Codec.LONG.optionalFieldOf("processed_ticks", (Object)0L).forGetter(PulseThrottler::processedTicks), (App)Codec.BOOL.optionalFieldOf("output", (Object)false).forGetter(PulseThrottler::output)).apply((Applicative)instance, PulseThrottler::new));
    public static final StreamCodec<ByteBuf, PulseThrottler> STREAM_CODEC = StreamCodec.composite(PulseThrottlerConfig.STREAM_CODEC, LogicComponent::config, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.BOOL, PulseThrottler::lastInput, (StreamCodec)ByteBufCodecs.VAR_LONG, PulseThrottler::processedTicks, (StreamCodec)ByteBufCodecs.BOOL, PulseThrottler::output, PulseThrottler::new);
    private boolean lastInputState;
    private long processedTicks;
    private boolean outputState;

    private PulseThrottler(PulseThrottlerConfig config, Optional<DyeColor> color, boolean lastInputState, long processedTicks, boolean outputState) {
        super(config, color);
        this.lastInputState = lastInputState;
        this.processedTicks = processedTicks;
        this.outputState = outputState;
    }

    private PulseThrottler(Optional<DyeColor> color, boolean lastInputState, long processedTicks, boolean outputState) {
        super(color);
        this.lastInputState = lastInputState;
        this.processedTicks = processedTicks;
        this.outputState = outputState;
    }

    public PulseThrottler() {
        this(Optional.empty(), false, 0L, false);
    }

    @Override
    protected PulseThrottlerConfig defaultConfig() {
        return new PulseThrottlerConfig();
    }

    @Override
    public LogicType<PulseThrottler> type() {
        return LogicTypes.PULSE_THROTTLER;
    }

    public boolean lastInput() {
        return this.lastInputState;
    }

    public long processedTicks() {
        return this.processedTicks;
    }

    @Override
    protected void processTickInternal(LogicContext context, boolean[] inputs) {
        boolean input = inputs[0];
        boolean output = false;
        boolean changed = false;
        if (this.processedTicks >= ((PulseThrottlerConfig)this.config).outputDuration) {
            this.processedTicks = 0L;
            output = false;
            changed = true;
        } else if (!this.lastInputState && input) {
            ++this.processedTicks;
            output = true;
            changed = true;
        } else if (this.processedTicks > 0L) {
            ++this.processedTicks;
            output = true;
            changed = true;
        }
        this.outputState = output;
        if (changed) {
            context.markDirty(this);
        }
        this.lastInputState = input;
    }

    @Override
    protected boolean outputInternal(int index) {
        return this.outputState;
    }

    public boolean output() {
        return this.output(0);
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicHelpPulseThrottler());
    }

    @Override
    protected void internalLoadFrom(PulseThrottler other) {
        this.lastInputState = other.lastInputState;
        this.processedTicks = other.processedTicks;
        this.outputState = other.outputState;
    }

    @Override
    protected void internalResetForPickup() {
        this.lastInputState = false;
        this.processedTicks = 0L;
        this.outputState = false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type(), this.config, this.color, this.processedTicks});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PulseThrottler)) return false;
        PulseThrottler other = (PulseThrottler)o;
        if (!Objects.equal((Object)this.config, (Object)other.config)) return false;
        if (!Objects.equal((Object)this.color, (Object)other.color)) return false;
        if (this.processedTicks != other.processedTicks) return false;
        return true;
    }
}

