/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.note;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.MicrochipObjectContainerType;
import net.swedz.tesseract.neoforge.api.Bounds;

public final class StickyNoteEntry
implements MicrochipObject {
    public static final Codec<StickyNoteEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("slot").forGetter(StickyNoteEntry::slot), (App)Codec.INT.fieldOf("x").forGetter(StickyNoteEntry::x), (App)Codec.INT.fieldOf("y").forGetter(StickyNoteEntry::y), (App)DyeColor.CODEC.fieldOf("color").forGetter(StickyNoteEntry::noteColor), (App)StickyNote.CODEC.fieldOf("note").forGetter(StickyNoteEntry::note), (App)DyeColor.CODEC.fieldOf("text_color").forGetter(StickyNoteEntry::textColor)).apply((Applicative)instance, StickyNoteEntry::new));
    public static final StreamCodec<ByteBuf, StickyNoteEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, StickyNoteEntry::slot, (StreamCodec)ByteBufCodecs.VAR_INT, StickyNoteEntry::x, (StreamCodec)ByteBufCodecs.VAR_INT, StickyNoteEntry::y, (StreamCodec)DyeColor.STREAM_CODEC, StickyNoteEntry::noteColor, StickyNote.STREAM_CODEC, StickyNoteEntry::note, (StreamCodec)DyeColor.STREAM_CODEC, StickyNoteEntry::textColor, StickyNoteEntry::new);
    private final int slot;
    private final int x;
    private final int y;
    private final DyeColor color;
    private StickyNote note;
    private DyeColor textColor;

    public StickyNoteEntry(int slot, int x, int y, DyeColor color, StickyNote note, DyeColor textColor) {
        this.slot = slot;
        this.x = x;
        this.y = y;
        this.color = color;
        this.note = note;
        this.textColor = textColor;
    }

    @Override
    public int slot() {
        return this.slot;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    public DyeColor noteColor() {
        return this.color;
    }

    public StickyNote note() {
        return this.note;
    }

    public void setNote(StickyNote note) {
        this.note = note;
    }

    public DyeColor textColor() {
        return this.textColor;
    }

    @Override
    public Optional<DyeColor> color() {
        return this.textColor == StickyNoteItem.getDefaultTextColor(this.color) ? Optional.empty() : Optional.of(this.textColor);
    }

    @Override
    public boolean setColor(Optional<DyeColor> color) {
        DyeColor resolvedColor;
        DyeColor original = this.textColor;
        this.textColor = resolvedColor = color.orElse(StickyNoteItem.getDefaultTextColor(this.color));
        return !original.equals((Object)resolvedColor);
    }

    @Override
    public MicrochipObjectContainerType containerType() {
        return MicrochipObjectContainerType.STICKY_NOTE;
    }

    @Override
    public ItemStack toStack() {
        ItemStack stack = new ItemStack(LBRItems.stickyNote(this.color));
        stack.set(LBRComponents.STICKY_NOTE, (Object)this.note);
        stack.set(LBRComponents.STICKY_NOTE_TEXT_COLOR, (Object)this.textColor);
        return stack;
    }

    @Override
    public Bounds toBounds() {
        return new Bounds(this.x, this.y, 16, 16);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StickyNoteEntry other = (StickyNoteEntry)o;
        return this.slot == other.slot && this.x == other.x && this.y == other.y && Objects.equals(this.color, other.color) && Objects.equals(this.note, other.note) && Objects.equals(this.textColor, other.textColor);
    }

    public int hashCode() {
        return Objects.hash(this.slot, this.x, this.y, this.color, this.note, this.textColor);
    }
}

