/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.tesseract.neoforge.helper.TransferHelper;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record QuickGrabMicrochipWireItemPacket(int containerId) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, QuickGrabMicrochipWireItemPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, QuickGrabMicrochipWireItemPacket::containerId, QuickGrabMicrochipWireItemPacket::new);

    /*
     * Enabled aggressive block sorting
     */
    public void handle(PacketContext context) {
        AbstractContainerMenu abstractContainerMenu;
        context.assertServerbound();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = player.getGameProfile().getName();
        if (player.hasContainerOpen() && (abstractContainerMenu = player.containerMenu) instanceof MicrochipMenu) {
            MicrochipMenu menu = (MicrochipMenu)abstractContainerMenu;
            if (menu.containerId == this.containerId) {
                ItemStack carried = menu.getCarried();
                if (!carried.isEmpty()) {
                    LBR.LOGGER.warn("Received QuickGrabMicrochipWireItemPacket from {} when carrying an item in the cursor", (Object)playerName);
                    return;
                }
                ItemStack extracted = TransferHelper.extractMatching((IItemHandler)menu.getLogicArrayItemHandler(), stack -> stack.is(LBRItems.REDSTONE_BIT.asItem()), (int)1);
                if (!extracted.isEmpty()) {
                    menu.setCarried(extracted);
                    return;
                }
                LBR.LOGGER.warn("Received QuickGrabMicrochipWireItemPacket from {} with no wire item to pull from the logic array", (Object)playerName);
                return;
            }
        }
        LBR.LOGGER.warn("Received QuickGrabMicrochipWireItemPacket from {} while not in a microchip menu (or in expired one?), discarding", (Object)playerName);
    }
}

