/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRRecipeTypes;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;

public final class CopyStickyNoteRecipe
extends CustomRecipe {
    public CopyStickyNoteRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        DyeColor color = null;
        DyeColor textColor = null;
        boolean hasSourceNote = false;
        boolean hasTargetNote = false;
        for (ItemStack stack : input.items()) {
            Item item = stack.getItem();
            if (item instanceof StickyNoteItem) {
                StickyNoteItem item2 = (StickyNoteItem)item;
                if (color != null && !color.equals((Object)item2.color())) {
                    return false;
                }
                color = item2.color();
                DyeColor stackTextColor = (DyeColor)stack.get(LBRComponents.STICKY_NOTE_TEXT_COLOR);
                if (textColor != null && !textColor.equals((Object)stackTextColor)) {
                    return false;
                }
                textColor = stackTextColor;
                StickyNote note = (StickyNote)stack.get(LBRComponents.STICKY_NOTE);
                if (note.isEmpty()) {
                    if (hasTargetNote) {
                        return false;
                    }
                    hasTargetNote = true;
                    continue;
                }
                if (hasSourceNote) {
                    return false;
                }
                hasSourceNote = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return hasSourceNote && hasTargetNote;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        DyeColor color = null;
        DyeColor textColor = null;
        ItemStack source = ItemStack.EMPTY;
        ItemStack target = ItemStack.EMPTY;
        for (ItemStack stack : input.items()) {
            Item item = stack.getItem();
            if (!(item instanceof StickyNoteItem)) continue;
            StickyNoteItem item2 = (StickyNoteItem)item;
            if (color != null && !color.equals((Object)item2.color())) {
                return ItemStack.EMPTY;
            }
            color = item2.color();
            DyeColor stackTextColor = (DyeColor)stack.get(LBRComponents.STICKY_NOTE_TEXT_COLOR);
            if (textColor != null && !textColor.equals((Object)stackTextColor)) {
                return ItemStack.EMPTY;
            }
            textColor = stackTextColor;
            StickyNote note = (StickyNote)stack.get(LBRComponents.STICKY_NOTE);
            if (note.isEmpty()) {
                target = stack;
                continue;
            }
            source = stack;
        }
        if (color != null && textColor != null && !source.isEmpty() && !target.isEmpty()) {
            return source.copyWithCount(2);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return LBRRecipeTypes.COPY_STICKY_NOTE_RECIPE_SERIALIZER.get();
    }
}

