/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.api.render.chunk;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.embeddedt.embeddium.api.render.chunk.EmbeddiumBlockAndTintGetter;
import org.embeddedt.embeddium.impl.render.matrix_stack.CachingPoseStack;
import org.embeddedt.embeddium.impl.render.world.WorldSliceLocalGenerator;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BlockRenderContext {
    private final EmbeddiumBlockAndTintGetter world;
    private final BlockAndTintGetter localSlice;
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private final Vector3f origin = new Vector3f();
    private final PoseStack stack = new PoseStack();
    private BlockState state;
    private BakedModel model;
    private long seed;
    private ModelData modelData;
    private RenderType renderLayer;

    public BlockRenderContext(EmbeddiumBlockAndTintGetter world) {
        this.world = world;
        this.localSlice = WorldSliceLocalGenerator.generate(world);
        ((CachingPoseStack)this.stack).embeddium$setCachingEnabled(true);
    }

    public void update(BlockPos pos, BlockPos origin, BlockState state, BakedModel model, long seed, ModelData modelData, RenderType renderLayer) {
        this.pos.set((Vec3i)pos);
        this.origin.set((float)origin.getX(), (float)origin.getY(), (float)origin.getZ());
        this.state = state;
        this.model = model;
        this.seed = seed;
        this.modelData = modelData;
        this.renderLayer = renderLayer;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public EmbeddiumBlockAndTintGetter world() {
        return this.world;
    }

    public BlockAndTintGetter localSlice() {
        return this.localSlice;
    }

    public BlockState state() {
        return this.state;
    }

    public PoseStack stack() {
        return this.stack;
    }

    public BakedModel model() {
        return this.model;
    }

    public Vector3fc origin() {
        return this.origin;
    }

    public long seed() {
        return this.seed;
    }

    public ModelData modelData() {
        return this.modelData;
    }

    public RenderType renderLayer() {
        return this.renderLayer;
    }
}

