/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.frame;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.Validate;
import org.embeddedt.embeddium.api.math.Dim2i;
import org.embeddedt.embeddium.api.options.OptionIdentifier;
import org.embeddedt.embeddium.api.options.control.Control;
import org.embeddedt.embeddium.api.options.control.ControlElement;
import org.embeddedt.embeddium.api.options.structure.Option;
import org.embeddedt.embeddium.api.options.structure.OptionGroup;
import org.embeddedt.embeddium.api.options.structure.OptionImpact;
import org.embeddedt.embeddium.api.options.structure.OptionPage;
import org.embeddedt.embeddium.impl.gui.frame.AbstractFrame;
import org.embeddedt.embeddium.impl.gui.widgets.AbstractWidget;
import org.embeddedt.embeddium.impl.util.PlatformUtil;
import org.jetbrains.annotations.Nullable;

public class OptionPageFrame
extends AbstractFrame {
    protected final OptionPage page;
    private long lastTime = 0L;
    private ControlElement<?> lastHoveredElement = null;
    protected final Predicate<Option<?>> optionFilter;

    public OptionPageFrame(Dim2i dim, boolean renderOutline, OptionPage page, Predicate<Option<?>> optionFilter) {
        super(dim, renderOutline);
        this.page = page;
        this.optionFilter = optionFilter;
        this.setupFrame();
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group : this.page.getGroups()) {
                int visibleOptionCount = (int)group.getOptions().stream().filter(this.optionFilter::test).count();
                y += visibleOptionCount * 18;
                if (visibleOptionCount <= 0 || group == lastGroup) continue;
                y += 4;
            }
        }
        this.dim = this.dim.withHeight(y);
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            boolean needPadding = false;
            for (Option option : group.getOptions()) {
                if (!this.optionFilter.test(option)) continue;
                Control control = option.getControl();
                Dim2i dim = new Dim2i(0, y, this.dim.width(), 18).withParentOffset(this.dim);
                ControlElement element = (ControlElement)control.createElement(dim);
                this.children.add(element);
                y += 18;
                needPadding = true;
            }
            if (!needPadding) continue;
            y += 4;
        }
        super.buildFrame();
    }

    @Override
    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(AbstractWidget::isHovered).findFirst().orElse(this.controlElements.stream().filter(AbstractWidget::isFocused).findFirst().orElse(null));
        super.render(drawContext, mouseX, mouseY, delta);
        if (hoveredElement != null && this.lastHoveredElement == hoveredElement && (this.dim.containsCursor(mouseX, mouseY) && hoveredElement.isHovered() && hoveredElement.isMouseOver(mouseX, mouseY) || hoveredElement.isFocused())) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            this.renderOptionTooltip(drawContext, hoveredElement);
        } else {
            this.lastTime = 0L;
            this.lastHoveredElement = hoveredElement;
        }
    }

    private static String normalizeModForTooltip(@Nullable String mod) {
        if (mod == null) {
            return null;
        }
        return switch (mod) {
            case "minecraft" -> "embeddium";
            default -> mod;
        };
    }

    private void renderOptionTooltip(GuiGraphics drawContext, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        if (this.lastTime + 500L > System.currentTimeMillis()) {
            return;
        }
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = dim.width();
        int boxY = dim.getLimitY();
        int boxX = dim.x();
        Option<?> option = element.getOption();
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>(Minecraft.getInstance().font.split((FormattedText)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(Language.getInstance().getVisualOrder((FormattedText)Component.translatable((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).withStyle(ChatFormatting.GRAY)));
        }
        OptionIdentifier<?> id = option.getId();
        if (OptionIdentifier.isPresent(this.page.getId()) && OptionIdentifier.isPresent(id) && !Objects.equals(OptionPageFrame.normalizeModForTooltip(this.page.getId().getModId()), OptionPageFrame.normalizeModForTooltip(id.getModId()))) {
            tooltip.add(Language.getInstance().getVisualOrder((FormattedText)Component.translatable((String)"embeddium.options.added_by_mod_string", (Object[])new Object[]{Component.literal((String)PlatformUtil.getModName(id.getModId())).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GRAY)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.dim.getLimitY())) {
            boxY -= boxHeight + dim.height();
        }
        if (boxY < 0) {
            boxY = dim.getLimitY();
        }
        drawContext.pose().pushPose();
        drawContext.pose().translate(0.0f, 0.0f, 90.0f);
        this.drawRect(drawContext, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        this.drawBorder(drawContext, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -3179338);
        for (int i = 0; i < tooltip.size(); ++i) {
            drawContext.drawString(Minecraft.getInstance().font, (FormattedCharSequence)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1, true);
        }
        drawContext.pose().popPose();
    }

    @Override
    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigation) {
        return super.nextFocusPath(navigation);
    }

    public static class Builder {
        private Dim2i dim;
        private boolean renderOutline;
        private OptionPage page;
        private Predicate<Option<?>> optionFilter = Predicates.alwaysTrue();

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder setOptionPage(OptionPage page) {
            this.page = page;
            return this;
        }

        public Builder setOptionFilter(Predicate<Option<?>> optionFilter) {
            this.optionFilter = optionFilter;
            return this;
        }

        public OptionPageFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.page, (String)"Option Page must be specified", (Object[])new Object[0]);
            return new OptionPageFrame(this.dim, this.renderOutline, this.page, this.optionFilter);
        }
    }
}

