/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.frame.tab;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import org.embeddedt.embeddium.api.math.Dim2i;
import org.embeddedt.embeddium.impl.Embeddium;
import org.embeddedt.embeddium.impl.gui.frame.tab.Tab;
import org.embeddedt.embeddium.impl.gui.widgets.FlatButtonWidget;

public class TabHeaderWidget
extends FlatButtonWidget {
    private static final ResourceLocation FALLBACK_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_pack.png");
    private static final Set<String> erroredLogos = new HashSet<String>();
    private final ResourceLocation logoTexture;

    public static MutableComponent getLabel(String modId) {
        return (switch (modId) {
            case "sspb" -> Component.literal((String)"SSPB");
            default -> Tab.idComponent(modId);
        }).withStyle(s -> s.withUnderlined(Boolean.valueOf(true)));
    }

    public TabHeaderWidget(Dim2i dim, String modId) {
        super(dim, (Component)TabHeaderWidget.getLabel(modId), () -> {});
        Optional logoFile = erroredLogos.contains(modId) ? Optional.empty() : ModList.get().getModContainerById(modId).flatMap(c -> c.getModInfo().getLogoFile());
        ResourceLocation texture = null;
        if (logoFile.isPresent()) {
            Pack.ResourcesSupplier supplier = ResourcePackLoader.getPackFor((String)modId).orElse((Pack.ResourcesSupplier)ResourcePackLoader.getPackFor((String)"neoforge").orElseThrow(() -> new RuntimeException("Can't find neoforge, WHAT!")));
            try (PackResources pack = supplier.openPrimary(new PackLocationInfo("mod:" + modId, (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty()));){
                IoSupplier logoResource = pack.getRootResource(new String[]{(String)logoFile.get()});
                if (logoResource != null) {
                    NativeImage logo = NativeImage.read((InputStream)((InputStream)logoResource.get()));
                    if (logo.getWidth() != logo.getHeight()) {
                        logo.close();
                        throw new IOException("Logo " + (String)logoFile.get() + " for " + modId + " is not square");
                    }
                    texture = ResourceLocation.fromNamespaceAndPath((String)"embeddium", (String)("logo/" + modId));
                    Minecraft.getInstance().getTextureManager().register(texture, (AbstractTexture)new DynamicTexture(logo));
                }
            }
            catch (IOException e) {
                erroredLogos.add(modId);
                Embeddium.logger().error("Exception reading logo for " + modId, (Throwable)e);
            }
        }
        this.logoTexture = texture;
    }

    @Override
    protected int getLeftAlignedTextOffset() {
        int n = super.getLeftAlignedTextOffset();
        Objects.requireNonNull(Minecraft.getInstance().font);
        return n + 9;
    }

    @Override
    protected boolean isHovered(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.render(drawContext, mouseX, mouseY, delta);
        ResourceLocation icon = Objects.requireNonNullElse(this.logoTexture, FALLBACK_LOCATION);
        Objects.requireNonNull(Minecraft.getInstance().font);
        int fontHeight = 9;
        int imgY = this.dim.getCenterY() - fontHeight / 2;
        drawContext.blit(icon, this.dim.x() + 5, imgY, 0.0f, 0.0f, fontHeight, fontHeight, fontHeight, fontHeight);
    }
}

