/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.core.world.map;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.Validate;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTracker;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTrackerHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public class ClientWorldMixin
implements ChunkTrackerHolder {
    @Unique
    private final ChunkTracker chunkTracker = new ChunkTracker();

    @Override
    public ChunkTracker sodium$getTracker() {
        return (ChunkTracker)Validate.notNull((Object)this.chunkTracker);
    }

    @Inject(method={"onChunkLoaded"}, at={@At(value="RETURN")})
    private void markLoaded(ChunkPos pChunkPos, CallbackInfo ci) {
        this.chunkTracker.onChunkStatusAdded(pChunkPos.x, pChunkPos.z, 1);
    }

    @Inject(method={"unload"}, at={@At(value="RETURN")})
    private void markUnloaded(LevelChunk chunk, CallbackInfo ci) {
        this.chunkTracker.onChunkStatusRemoved(chunk.getPos().x, chunk.getPos().z, 1);
    }
}

