/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.light.flat;

import java.util.Arrays;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.embeddedt.embeddium.api.util.NormI8;
import org.embeddedt.embeddium.impl.Embeddium;
import org.embeddedt.embeddium.impl.model.light.LightPipeline;
import org.embeddedt.embeddium.impl.model.light.data.LightDataAccess;
import org.embeddedt.embeddium.impl.model.light.data.QuadLightData;
import org.embeddedt.embeddium.impl.model.quad.ModelQuadView;

public class FlatLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;
    private final boolean useQuadNormalsForShading;

    public FlatLightPipeline(LightDataAccess lightCache) {
        this.lightCache = lightCache;
        this.useQuadNormalsForShading = Embeddium.options().quality.useQuadNormalsForShading;
    }

    @Override
    public void calculate(ModelQuadView quad, BlockPos pos, QuadLightData out, Direction cullFace, Direction lightFace, boolean shade) {
        int flags;
        int lightmap = cullFace != null ? this.getOffsetLightmap(pos, cullFace) : (((flags = quad.getFlags()) & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(pos)) ? this.getOffsetLightmap(pos, lightFace) : LightDataAccess.getEmissiveLightmap(this.lightCache.get(pos)));
        Arrays.fill(out.lm, lightmap);
        if ((quad.getFlags() & 8) != 0 || !this.useQuadNormalsForShading) {
            Arrays.fill(out.br, this.lightCache.getWorld().getShade(lightFace, shade));
        } else {
            this.applySidedBrightnessFromNormals(quad, out, shade);
        }
    }

    private void applySidedBrightnessFromNormals(ModelQuadView quad, QuadLightData out, boolean shade) {
        int normal = quad.getModFaceNormal();
        Arrays.fill(out.br, this.lightCache.getWorld().getShade(NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal), shade));
    }

    private int getOffsetLightmap(BlockPos pos, Direction face) {
        int word = this.lightCache.get(pos);
        if (LightDataAccess.unpackEM(word)) {
            return 0xF000F0;
        }
        int adjWord = this.lightCache.get(pos, face);
        return LightTexture.pack((int)Math.max(LightDataAccess.unpackBL(adjWord), LightDataAccess.unpackLU(word)), (int)LightDataAccess.unpackSL(adjWord));
    }
}

