/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.items.book;

import com.github.jarva.allthearcanistgear.setup.registry.AddonDataComponentRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellSlotMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class ExtendedGlyphCasterData
extends AbstractCaster<ExtendedGlyphCasterData> {
    private static final MapCodec<ExtendedGlyphCasterData> BASE_CODEC = ExtendedGlyphCasterData.createCodec(ExtendedGlyphCasterData::new);
    public static final MapCodec<ExtendedGlyphCasterData> CODEC = Codec.mapPair(BASE_CODEC, (MapCodec)Codec.INT.fieldOf("bonus_slots")).xmap(pair -> {
        ExtendedGlyphCasterData data = (ExtendedGlyphCasterData)((Object)((Object)pair.getFirst()));
        data.bonusSlots = (Integer)pair.getSecond();
        return data;
    }, instance -> Pair.of((Object)instance, (Object)instance.bonusSlots));
    private static final StreamCodec<RegistryFriendlyByteBuf, ExtendedGlyphCasterData> BASE_STREAM_CODEC = ExtendedGlyphCasterData.createStream(ExtendedGlyphCasterData::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, ExtendedGlyphCasterData> STREAM_CODEC = StreamCodec.composite(BASE_STREAM_CODEC, Function.identity(), (StreamCodec)ByteBufCodecs.INT, s -> s.bonusSlots, ExtendedGlyphCasterData::fromStream);
    public int bonusSlots = 0;

    public ExtendedGlyphCasterData(int maxSlots) {
        super(maxSlots);
    }

    public ExtendedGlyphCasterData(int maxSlots, SpellCaster data) {
        super(data.getCurrentSlot(), data.getFlavorText(), Boolean.valueOf(data.isSpellHidden()), data.getFlavorText(), maxSlots, data.getSpells());
    }

    public ExtendedGlyphCasterData(Integer slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        super(slot.intValue(), flavorText, isHidden, hiddenText, maxSlots, spells);
    }

    private static ExtendedGlyphCasterData fromStream(ExtendedGlyphCasterData data, int bonusSlots) {
        data.bonusSlots = bonusSlots;
        return data;
    }

    public int getBonusGlyphSlots() {
        return this.bonusSlots;
    }

    public MapCodec<ExtendedGlyphCasterData> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ExtendedGlyphCasterData> streamCodec() {
        return STREAM_CODEC;
    }

    public DataComponentType<ExtendedGlyphCasterData> getComponentType() {
        return (DataComponentType)AddonDataComponentRegistry.EXTENDED_GLYPH_CASTER.get();
    }

    protected ExtendedGlyphCasterData build(int slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        return new ExtendedGlyphCasterData(slot, flavorText, isHidden, hiddenText, maxSlots, spells);
    }
}

