/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel_patcher.config;

import dev.djefrey.colorwheel_patcher.config.ClrwlConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public record ProcessedConfig(List<PatchConfig> patches) {
    public static ProcessedConfig processConfigs(ClrwlConfig jarConfig, ClrwlConfig userConfig) {
        ArrayList<PatchConfig> patches = new ArrayList<PatchConfig>();
        ProcessedConfig.addPatchesFromConfig(userConfig, true, patches);
        ProcessedConfig.addPatchesFromConfig(jarConfig, false, patches);
        return new ProcessedConfig(patches);
    }

    private static void addPatchesFromConfig(ClrwlConfig config, boolean userConfig, List<PatchConfig> patches) {
        for (ClrwlConfig.PatchConfig patch : config.patches()) {
            if (patches.stream().anyMatch(p -> p.shaderName().equals(patch.shaderName()))) continue;
            patches.add(PatchConfig.fromFileEntry(patch, userConfig));
        }
    }

    public record PatchConfig(String shaderName, List<String> versions, List<String> aliases, boolean userPatch) {
        public static PatchConfig fromFileEntry(ClrwlConfig.PatchConfig entry, boolean userConfig) {
            return new PatchConfig(entry.shaderName(), entry.versions(), entry.aliases(), userConfig);
        }

        public InputStream getPatchZip(Path configPath) throws FileNotFoundException {
            InputStream res = this.userPatch ? new FileInputStream(configPath.resolve("/patches/" + this.shaderName + ".zip").toFile()) : this.getClass().getResourceAsStream("/patches/" + this.shaderName + ".zip");
            if (res == null) {
                throw new FileNotFoundException();
            }
            return res;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean doesMatchWith(String str) {
            if (str.contains(this.shaderName)) return true;
            if (!this.aliases.stream().anyMatch(str::contains)) return false;
            return true;
        }
    }
}

