/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.integration;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.table.SewingInput;
import dev.gigaherz.toolbelt.belt.ToolBeltItem;
import dev.gigaherz.toolbelt.integration.SewingKitIntegration;
import dev.gigaherz.toolbelt.integration.SewingUpgradeRecipeBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class SewingUpgradeRecipe
extends SewingRecipe {
    public static final MapCodec<SewingUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> SewingUpgradeRecipe.defaultSewingFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SewingUpgradeRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SewingUpgradeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SewingKitMod.nullable((StreamCodec)ByteBufCodecs.STRING_UTF8), SewingRecipe::getGroup, (StreamCodec)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)SewingRecipe.Material.STREAM_CODEC), SewingRecipe::getMaterials, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), SewingRecipe::getPattern, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), SewingRecipe::getTool, (StreamCodec)ItemStack.STREAM_CODEC, SewingRecipe::getOutput, (StreamCodec)ByteBufCodecs.BOOL, SewingRecipe::showNotification, SewingUpgradeRecipe::new);

    public static SewingUpgradeRecipeBuilder builder(Item result, int count) {
        return new SewingUpgradeRecipeBuilder(new ItemStack((ItemLike)result, count));
    }

    public static SewingUpgradeRecipeBuilder builder(ItemStack result) {
        return new SewingUpgradeRecipeBuilder(result);
    }

    public SewingUpgradeRecipe(String group, NonNullList<SewingRecipe.Material> materials, Optional<Ingredient> pattern, Optional<Ingredient> tool, ItemStack output, boolean showNotification) {
        super(group, materials, pattern, tool, output, showNotification);
    }

    public SewingUpgradeRecipe(String group, NonNullList<SewingRecipe.Material> materials, @Nullable Ingredient pattern, @Nullable Ingredient tool, ItemStack output, boolean showNotification) {
        super(group, materials, pattern, tool, output, showNotification);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SewingKitIntegration.SEWING_UGRADE_SERIALIZER.get();
    }

    public ItemStack assemble(SewingInput inv, HolderLookup.Provider provider) {
        ItemStack inputBelt = ItemStack.EMPTY;
        for (int i = 2; i < 6; ++i) {
            if (!(inv.getItem(i).getItem() instanceof ToolBeltItem)) continue;
            inputBelt = inv.getItem(i);
            break;
        }
        ItemStack upgradedBelt = super.assemble(inv, provider);
        if (inputBelt.getCount() > 0) {
            int size = 2;
            DataComponentPatch inputTag = inputBelt.getComponentsPatch();
            if (!inputTag.isEmpty()) {
                size = ToolBeltItem.getSlotsCount(upgradedBelt);
                upgradedBelt.applyComponents(inputTag);
            }
            ToolBeltItem.setSlotsCount(upgradedBelt, Mth.clamp((int)size, (int)2, (int)9));
        }
        return upgradedBelt;
    }

    public static class Serializer
    implements RecipeSerializer<SewingUpgradeRecipe> {
        public MapCodec<SewingUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SewingUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

