/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.QpBlock;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class QpEntityBlock
extends QpBlock
implements EntityBlock {
    public QpEntityBlock(BlockBehaviour.Properties properties, String name, Function<? super QpBlock, ? extends BlockItem> itemGenerator) {
        super(properties, name, itemGenerator);
    }

    protected <T extends BlockEntity> Optional<BlockEntityType<T>> getBlockEntityType() {
        return PlatformAccess.getAccess().registerObjects().getBlockEntityType(this).map(e -> e);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.getBlockEntityType().map(t -> t.create(pos, state)).orElse(null);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }
}

