/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.machine.advquarry.AdvQuarryState;
import com.yogpc.qp.machine.module.ModuleContainer;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class AdvActionActionMessage
implements CustomPacketPayload,
OnReceiveWithLevel {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"adv_action_action_message");
    public static final CustomPacketPayload.Type<AdvActionActionMessage> TYPE = new CustomPacketPayload.Type(NAME);
    public static final StreamCodec<FriendlyByteBuf, AdvActionActionMessage> STREAM_CODEC = CustomPacketPayload.codec(AdvActionActionMessage::write, AdvActionActionMessage::new);
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final Action action;

    AdvActionActionMessage(BlockPos pos, ResourceKey<Level> dim, Action action) {
        this.action = action;
        this.pos = pos;
        this.dim = dim;
    }

    AdvActionActionMessage(AdvQuarryEntity entity, Action action) {
        this(entity.getBlockPos(), (ResourceKey<Level>)Objects.requireNonNull(entity.getLevel()).dimension(), action);
    }

    AdvActionActionMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.dim = buffer.readResourceKey(Registries.DIMENSION);
        this.action = (Action)buffer.readEnum(Action.class);
    }

    void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos).writeResourceKey(this.dim);
        buffer.writeEnum((Enum)this.action);
    }

    @Override
    public void onReceive(Level level, Player player) {
        if (!level.dimension().equals(this.dim)) {
            return;
        }
        BlockEntity entity = level.getBlockEntity(this.pos);
        if (entity instanceof AdvQuarryEntity) {
            AdvQuarryEntity quarry = (AdvQuarryEntity)entity;
            if (quarry.enabled) {
                switch (this.action.ordinal()) {
                    case 1: {
                        if (!(player instanceof ServerPlayer)) break;
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (PlatformAccess.getAccess().platformName().equalsIgnoreCase("fabric")) break;
                        PlatformAccess.getAccess().openGui(serverPlayer, new GeneralScreenHandler<ModuleContainer>(quarry, ModuleContainer::new));
                        break;
                    }
                    case 0: {
                        if (quarry.currentState != AdvQuarryState.WAITING) break;
                        quarry.workConfig = quarry.workConfig.startSoonConfig();
                        quarry.startQuarryWork();
                    }
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static enum Action {
        QUICK_START,
        MODULE_INV;

    }
}

