/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.EnchantmentCache;
import com.yogpc.qp.machine.ItemConverter;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.PickIterator;
import com.yogpc.qp.machine.PowerEntity;
import com.yogpc.qp.machine.PowerMap;
import com.yogpc.qp.machine.QpBlockProperty;
import com.yogpc.qp.machine.WorkResult;
import com.yogpc.qp.machine.advquarry.AdvQuarryState;
import com.yogpc.qp.machine.advquarry.AdvQuarryTarget;
import com.yogpc.qp.machine.advquarry.WorkConfig;
import com.yogpc.qp.machine.exp.ExpModule;
import com.yogpc.qp.machine.misc.BlockBreakEventResult;
import com.yogpc.qp.machine.misc.DigMinY;
import com.yogpc.qp.machine.misc.QuarryChunkLoader;
import com.yogpc.qp.machine.module.ConverterModule;
import com.yogpc.qp.machine.module.ModuleInventory;
import com.yogpc.qp.machine.module.QuarryModule;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import com.yogpc.qp.machine.module.RepeatTickModuleItem;
import com.yogpc.qp.packet.ClientSync;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AdvQuarryEntity
extends PowerEntity
implements ClientSync {
    public static final Marker MARKER = MarkerFactory.getMarker((String)"advQuarry");
    @NotNull
    AdvQuarryState currentState = AdvQuarryState.FINISHED;
    @Nullable
    private Area area;
    @Nullable
    private PickIterator<BlockPos> targetIterator;
    @Nullable
    BlockPos targetPos;
    @NotNull
    MachineStorage storage = MachineStorage.of();
    @NotNull
    WorkConfig workConfig = WorkConfig.DEFAULT;
    @NotNull
    public DigMinY digMinY = new DigMinY();
    @NotNull
    final EnchantmentCache enchantmentCache = new EnchantmentCache();
    @NotNull
    Set<QuarryModule> modules = Collections.emptySet();
    @NotNull
    final ModuleInventory moduleInventory = new ModuleInventory(5, AdvQuarryEntity::moduleFilter, m -> this.modules, this::setChanged);
    boolean searchEnergyConsumed = false;
    @NotNull
    QuarryChunkLoader chunkLoader = QuarryChunkLoader.None.INSTANCE;
    @NotNull
    ItemConverter itemConverter = AdvQuarryEntity.defaultItemConverter();

    protected AdvQuarryEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.setMaxEnergy((long)(AdvQuarryEntity.powerMap().maxEnergy() * 1.0E9));
    }

    static PowerMap.AdvQuarry powerMap() {
        return PlatformAccess.config().powerMap().advQuarry();
    }

    static void serverTick(Level level, BlockPos pos, BlockState state, AdvQuarryEntity quarry) {
        block7: for (int i = 0; i < quarry.repeatCount(); ++i) {
            if (!quarry.hasEnoughEnergy()) {
                return;
            }
            AdvQuarryState advQuarryState = quarry.currentState;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FINISHED", "WAITING", "MAKE_FRAME", "BREAK_BLOCK", "CLEAN_UP"}, (AdvQuarryState)advQuarryState, n)) {
                case 0: {
                    return;
                }
                case 1: {
                    quarry.waiting();
                    return;
                }
                case 2: {
                    quarry.makeFrame();
                    continue block7;
                }
                case 3: {
                    quarry.breakBlock();
                    continue block7;
                }
                case 4: {
                    quarry.cleanUp();
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("Not implemented: " + String.valueOf((Object)quarry.currentState));
                }
            }
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fromClientTag(tag, registries);
        BlockPos current = BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("targetPos")).result().orElse(null);
        this.workConfig = WorkConfig.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("workConfig")).result().orElse(WorkConfig.DEFAULT);
        this.targetIterator = AdvQuarryEntity.createTargetIterator(this.currentState, this.area, current, this.workConfig);
        this.targetPos = current;
        this.storage = MachineStorage.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("storage")).result().orElseGet(MachineStorage::of);
        this.moduleInventory.fromTag(tag.getList("moduleInventory", 10), registries);
        this.chunkLoader = QuarryChunkLoader.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("chunkLoader")).result().orElse(QuarryChunkLoader.None.INSTANCE);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.toClientTag(tag, registries);
        tag.put("workConfig", (Tag)WorkConfig.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.workConfig).getOrThrow());
        if (this.targetIterator != null) {
            tag.put("targetPos", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.targetIterator.getLastReturned()).getOrThrow());
        }
        tag.put("storage", (Tag)MachineStorage.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.storage).getOrThrow());
        tag.put("moduleInventory", (Tag)this.moduleInventory.createTag(registries));
        tag.put("chunkLoader", (Tag)QuarryChunkLoader.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.chunkLoader).getOrThrow());
    }

    @Override
    public void fromClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.currentState = AdvQuarryState.valueOf(tag.getString("state"));
        this.area = Area.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("area")).result().orElse(null);
        this.digMinY = DigMinY.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("digMinY")).result().orElseGet(DigMinY::new);
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putString("state", this.currentState.name());
        if (this.area != null) {
            tag.put("area", (Tag)Area.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.area).getOrThrow());
        }
        tag.put("digMinY", (Tag)DigMinY.CODEC.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.digMinY).getOrThrow());
        return tag;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
    }

    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        stack.applyComponents(this.collectComponents());
    }

    public void setChanged() {
        super.setChanged();
        this.updateModules();
    }

    public void setRemoved() {
        super.setRemoved();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            this.chunkLoader.makeChunkUnLoaded(s);
        }
    }

    @Override
    public Stream<MutableComponent> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(AdvQuarryEntity.detail(ChatFormatting.GREEN, "State", this.currentState.name()), AdvQuarryEntity.detail(ChatFormatting.GREEN, "Area", String.valueOf(this.area)), AdvQuarryEntity.detail(ChatFormatting.GREEN, "Target", String.valueOf(this.targetPos)), AdvQuarryEntity.detail(ChatFormatting.GREEN, "TargetIterator", this.targetIterator != null ? this.targetIterator.getClass().getSimpleName() : "null"), AdvQuarryEntity.detail(ChatFormatting.GREEN, "Storage", String.valueOf(this.storage)), AdvQuarryEntity.detail(ChatFormatting.GREEN, "DigMinY", String.valueOf(this.digMinY.getMinY((LevelReader)this.level))), AdvQuarryEntity.detail(ChatFormatting.GREEN, "Modules", String.valueOf(this.modules)), AdvQuarryEntity.detail(ChatFormatting.GREEN, "Enchantment", String.valueOf(this.enchantmentCache))));
    }

    @Override
    public final void updateMaxEnergyWithEnchantment(Level level) {
        int efficiency = this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, level.registryAccess().asGetterLookup());
        this.setMaxEnergy((long)(AdvQuarryEntity.powerMap().maxEnergy() * 1.0E9 * (double)(1 + efficiency)));
    }

    public void setArea(@Nullable Area area) {
        this.area = area;
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    void setState(AdvQuarryState state, BlockState blockState) {
        if (this.level != null && this.currentState != state) {
            if (!this.level.isClientSide) {
                if (!AdvQuarryState.isWorking(this.currentState) && AdvQuarryState.isWorking(state)) {
                    this.chunkLoader = QuarryChunkLoader.of((ServerLevel)this.level, this.getBlockPos());
                    this.chunkLoader.makeChunkLoaded((ServerLevel)this.level);
                } else if (AdvQuarryState.isWorking(this.currentState) && !AdvQuarryState.isWorking(state)) {
                    this.chunkLoader.makeChunkUnLoaded((ServerLevel)this.level);
                    this.chunkLoader = QuarryChunkLoader.None.INSTANCE;
                }
            }
            this.currentState = state;
            this.syncToClient();
            this.level.setBlock(this.getBlockPos(), (BlockState)blockState.setValue((Property)QpBlockProperty.WORKING, (Comparable)Boolean.valueOf(AdvQuarryState.isWorking(state))), 3);
            if (state == AdvQuarryState.FINISHED) {
                this.energyCounter.logUsageMap();
            }
        }
    }

    public String renderMode() {
        return switch (this.currentState) {
            case AdvQuarryState.WAITING, AdvQuarryState.MAKE_FRAME -> "frame";
            default -> "none";
        };
    }

    void updateModules() {
        this.modules = this.level == null ? this.moduleInventory.getModules() : Sets.union(this.moduleInventory.getModules(), QuarryModuleProvider.Block.getModulesInWorld(this.level, this.getBlockPos()));
        this.itemConverter = AdvQuarryEntity.defaultItemConverter().concat(ConverterModule.findConversions(this.modules));
    }

    protected int repeatCount() {
        RepeatTickModuleItem.RepeatTickModule repeatTickModule = RepeatTickModuleItem.getModule(this.modules).orElse(RepeatTickModuleItem.ZERO);
        return repeatTickModule.stackSize() + 1;
    }

    protected boolean shouldRemoveBedrock() {
        return this.modules.contains(QuarryModule.Constant.BEDROCK);
    }

    @NotNull
    protected Optional<ExpModule> getExpModule() {
        return ExpModule.getModule(this.modules);
    }

    @Nullable
    static PickIterator<BlockPos> createTargetIterator(@NotNull AdvQuarryState currentState, @Nullable Area area, BlockPos current, WorkConfig config) {
        if (area == null) {
            return null;
        }
        if (currentState == AdvQuarryState.MAKE_FRAME) {
            PickIterator<BlockPos> iterator = area.quarryFramePosIterator();
            iterator.setLastReturned(current);
            return iterator;
        }
        if (currentState == AdvQuarryState.BREAK_BLOCK || currentState == AdvQuarryState.CLEAN_UP) {
            AdvQuarryTarget iterator = config.chunkByChunk() ? new AdvQuarryTarget.ChunkByChunk(area) : new AdvQuarryTarget.North(area);
            ((PickIterator)iterator).setLastReturned(current);
            return iterator;
        }
        return null;
    }

    void waiting() {
        if (!this.workConfig.startImmediately()) {
            return;
        }
        if (this.getEnergy() > this.getMaxEnergy() / 200L && this.area != null) {
            this.startQuarryWork();
        }
    }

    void startQuarryWork() {
        AdvQuarryState next = this.workConfig.placeAreaFrame() ? AdvQuarryState.MAKE_FRAME : AdvQuarryState.BREAK_BLOCK;
        this.setState(next, this.getBlockState());
    }

    void makeFrame() {
        WorkResult result;
        BlockState state;
        if (this.level == null || this.level.isClientSide() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = AdvQuarryEntity.createTargetIterator(this.currentState, this.getArea(), null, this.workConfig);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.targetIterator.next();
        }
        if ((state = this.level.getBlockState(this.targetPos)).is((Block)PlatformAccess.getAccess().registerObjects().frameBlock().get())) {
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
                this.makeFrame();
            } else {
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(AdvQuarryState.BREAK_BLOCK, this.getBlockState());
            }
            return;
        }
        if (!(this.getBlockPos().equals((Object)this.targetPos) || state.isAir() || (result = this.breakOneBlock(this.targetPos)).isSuccess())) {
            return;
        }
        long requiredEnergy = (long)(1.0E9 * AdvQuarryEntity.powerMap().makeFrame());
        if (this.useEnergy(requiredEnergy, true, false, "makeFrame") == requiredEnergy) {
            this.useEnergy(requiredEnergy, false, false, "makeFrame");
            if (!this.targetPos.equals((Object)this.getBlockPos())) {
                this.level.setBlock(this.targetPos, PlatformAccess.getAccess().registerObjects().frameBlock().get().defaultBlockState(), 3);
            }
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
            } else {
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(AdvQuarryState.BREAK_BLOCK, this.getBlockState());
            }
        }
    }

    void breakBlock() {
        if (this.level == null || this.level.isClientSide() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = AdvQuarryEntity.createTargetIterator(this.currentState, this.getArea(), null, this.workConfig);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.targetIterator.next();
            assert (this.targetPos != null);
        }
        WorkResult result = null;
        while (result == null || result == WorkResult.SKIPPED) {
            if (this.targetPos == null) {
                return;
            }
            if (!this.searchEnergyConsumed) {
                long used;
                long energy = (long)AdvQuarryEntity.powerMap().searchBase() * 1000000000L * (long)this.targetPos.getY();
                if (energy != (used = this.useEnergy(energy, false, false, "searchEnergy"))) {
                    return;
                }
                this.searchEnergyConsumed = true;
            }
            if ((result = this.breakBlocks(this.targetPos.getX(), this.targetPos.getZ())).isSuccess()) {
                this.searchEnergyConsumed = false;
                if (this.targetIterator.hasNext()) {
                    this.targetPos = this.targetIterator.next();
                    continue;
                }
                this.targetIterator = null;
                this.targetPos = null;
                this.setState(AdvQuarryState.CLEAN_UP, this.getBlockState());
                return;
            }
            if (result != WorkResult.NOT_ENOUGH_ENERGY) continue;
            return;
        }
    }

    void cleanUp() {
        if (this.level == null || this.level.isClientSide() || this.area == null) {
            return;
        }
        if (this.targetIterator == null) {
            this.targetIterator = AdvQuarryEntity.createTargetIterator(this.currentState, this.getArea(), null, this.workConfig);
            assert (this.targetIterator != null);
        }
        if (this.targetPos == null) {
            this.targetPos = this.targetIterator.next();
            assert (this.targetPos != null);
        }
        int count = 0;
        while (count < 32 && this.currentState == AdvQuarryState.CLEAN_UP) {
            if (this.targetPos == null) {
                return;
            }
            WorkResult result = this.cleanUpFluid(this.targetPos.getX(), this.targetPos.getZ());
            if (result.isSuccess()) {
                ++count;
            }
            if (this.targetIterator.hasNext()) {
                this.targetPos = this.targetIterator.next();
                continue;
            }
            this.targetIterator = null;
            this.targetPos = null;
            this.setState(AdvQuarryState.FINISHED, this.getBlockState());
            return;
        }
    }

    @NotNull
    WorkResult breakOneBlock(BlockPos target) {
        assert (this.level != null);
        ServerLevel serverLevel = (ServerLevel)this.level;
        BlockState state = serverLevel.getBlockState(target);
        if (state.isAir() || state.equals(this.stateAfterBreak((Level)serverLevel, target, state))) {
            return WorkResult.SUCCESS;
        }
        HolderGetter.Provider lookup = serverLevel.registryAccess().asGetterLookup();
        BlockEntity blockEntity = serverLevel.getBlockEntity(target);
        ServerPlayer player = this.getQuarryFakePlayer(serverLevel, target);
        ItemStack pickaxe = Items.NETHERITE_PICKAXE.getDefaultInstance();
        EnchantmentHelper.setEnchantments((ItemStack)pickaxe, (ItemEnchantments)this.enchantmentCache.getEnchantmentsForPickaxe(this.getEnchantments(), lookup));
        player.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        float hardness = state.getDestroySpeed((BlockGetter)serverLevel, target);
        BlockBreakEventResult eventResult = this.checkBreakEvent((Level)serverLevel, player, state, target, blockEntity);
        if (eventResult.canceled()) {
            return WorkResult.FAIL_EVENT;
        }
        WorkResult moduleResult = this.breakBlockModuleOverride(serverLevel, state, target, hardness);
        if (moduleResult != WorkResult.SKIPPED) {
            return moduleResult;
        }
        if (hardness < 0.0f) {
            return WorkResult.SKIPPED;
        }
        long requiredEnergy = AdvQuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.FORTUNE, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, lookup) > 0);
        this.useEnergy(requiredEnergy, false, true, "breakBlock");
        BlockBreakEventResult afterBreakEventResult = this.afterBreak((Level)serverLevel, player, state, target, blockEntity, Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)target, (BlockEntity)blockEntity, (Entity)player, (ItemStack)pickaxe), pickaxe, this.stateAfterBreak((Level)serverLevel, target, state));
        if (!afterBreakEventResult.canceled()) {
            afterBreakEventResult.drops().stream().flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
            int amount = eventResult.exp().orElse(afterBreakEventResult.exp().orElse(0));
            if (amount != 0) {
                this.getExpModule().ifPresent(e -> e.addExp(amount));
            }
        }
        assert (this.area != null);
        for (BlockPos edge : this.area.getEdgeForPos(target)) {
            if (this.level.getFluidState(edge).isEmpty()) continue;
            this.useEnergy((long)(AdvQuarryEntity.powerMap().breakBlockFluid() * 1.0E9), false, true, "removeFluid");
            this.removeFluidAt(this.level, edge, player, PlatformAccess.getAccess().registerObjects().frameBlock().get().getDammingState());
        }
        return WorkResult.SUCCESS;
    }

    @NotNull
    WorkResult breakBlocks(int x, int z) {
        BlockState state;
        assert (this.level != null);
        ServerLevel serverLevel = (ServerLevel)this.level;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, this.getBlockPos().getY() - 1, z);
        HolderGetter.Provider lookup = serverLevel.registryAccess().asGetterLookup();
        ServerPlayer player = this.getQuarryFakePlayer(serverLevel, (BlockPos)mutableBlockPos);
        ItemStack pickaxe = Items.NETHERITE_PICKAXE.getDefaultInstance();
        EnchantmentHelper.setEnchantments((ItemStack)pickaxe, (ItemEnchantments)this.enchantmentCache.getEnchantmentsForPickaxe(this.getEnchantments(), lookup));
        player.setItemInHand(InteractionHand.MAIN_HAND, pickaxe);
        AABB aabb = new AABB((double)(x - 5), (double)(this.digMinY.getMinY((LevelReader)serverLevel) - 5), (double)(z - 5), (double)(x + 5), (double)(this.getBlockPos().getY() - 1), (double)(z + 5));
        serverLevel.getEntitiesOfClass(ItemEntity.class, aabb, Predicate.not(i -> i.getItem().isEmpty())).forEach(i -> {
            this.itemConverter.convert(i.getItem()).forEach(this.storage::addItem);
            i.kill();
        });
        serverLevel.getEntitiesOfClass(FallingBlockEntity.class, aabb).forEach(i -> {
            this.itemConverter.convert(new ItemStack((ItemLike)i.getBlockState().getBlock())).forEach(this.storage::addItem);
            i.discard();
        });
        this.getExpModule().ifPresent(e -> serverLevel.getEntitiesOfClass(ExperienceOrb.class, aabb, EntitySelector.ENTITY_STILL_ALIVE).forEach(orb -> {
            e.addExp(orb.getValue());
            orb.kill();
        }));
        if (this.shouldRemoveMinecarts()) {
            serverLevel.getEntitiesOfClass(MinecartChest.class, aabb).forEach(chest -> {
                IntStream.range(0, chest.getContainerSize()).mapToObj(arg_0 -> ((MinecartChest)chest).getItem(arg_0)).flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
                chest.clearContent();
                chest.kill();
            });
        }
        this.removeEdgeFluid(x, z, serverLevel, player);
        long requiredEnergy = 0L;
        AtomicInteger exp = new AtomicInteger(0);
        ArrayList<Pair> toBreak = new ArrayList<Pair>();
        ArrayList<Pair> toDrain = new ArrayList<Pair>();
        HashSet<BlockPos.MutableBlockPos> handled = new HashSet<BlockPos.MutableBlockPos>();
        HashMap<BlockPos, BlockBreakEventResult> resultMap = new HashMap<BlockPos, BlockBreakEventResult>();
        for (int y = this.getBlockPos().getY() - 1; y >= this.digMinY.getMinY((LevelReader)serverLevel); --y) {
            mutableBlockPos.setY(y);
            BlockState state2 = serverLevel.getBlockState((BlockPos)mutableBlockPos);
            FluidState fluidState = serverLevel.getFluidState((BlockPos)mutableBlockPos);
            if (fluidState.isEmpty()) {
                if (state2.isAir()) continue;
                BlockEntity blockEntity = serverLevel.getBlockEntity((BlockPos)mutableBlockPos);
                float hardness = state2.getDestroySpeed((BlockGetter)serverLevel, (BlockPos)mutableBlockPos);
                BlockBreakEventResult eventResult = this.checkBreakEvent((Level)serverLevel, player, state2, (BlockPos)mutableBlockPos, blockEntity);
                if (eventResult.canceled()) continue;
                WorkResult moduleResult = this.breakBlockModuleOverride(serverLevel, state2, (BlockPos)mutableBlockPos, hardness);
                if (moduleResult != WorkResult.SKIPPED) {
                    handled.add(mutableBlockPos);
                    continue;
                }
                if (hardness < 0.0f) continue;
                long energy = AdvQuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.FORTUNE, lookup), this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, lookup) > 0);
                requiredEnergy += energy;
                toBreak.add(Pair.of((Object)mutableBlockPos.immutable(), (Object)state2));
                resultMap.put(mutableBlockPos.immutable(), eventResult);
                continue;
            }
            long energy = (long)AdvQuarryEntity.powerMap().breakBlockFluid() * 1000000000L;
            requiredEnergy += energy;
            toDrain.add(Pair.of((Object)mutableBlockPos.immutable(), (Object)state2));
        }
        if (toBreak.isEmpty() && toDrain.isEmpty()) {
            if (handled.isEmpty()) {
                return WorkResult.SKIPPED;
            }
            return WorkResult.SUCCESS;
        }
        this.useEnergy(requiredEnergy, false, true, "breakBlock");
        for (Pair pair : toDrain) {
            Block energy = ((BlockState)pair.getRight()).getBlock();
            if (energy instanceof BucketPickup) {
                BucketPickup fluidBlock = (BucketPickup)energy;
                ItemStack bucketItem = fluidBlock.pickupBlock((Player)player, (LevelAccessor)serverLevel, (BlockPos)pair.getLeft(), (BlockState)pair.getRight());
                this.storage.addBucketFluid(bucketItem);
            }
            if (!(state = serverLevel.getBlockState((BlockPos)pair.getLeft())).isAir()) {
                this.breakOneBlock((BlockPos)pair.getLeft());
            }
            serverLevel.setBlock((BlockPos)pair.getLeft(), PlatformAccess.getAccess().registerObjects().softBlock().get().defaultBlockState(), 18);
        }
        for (Pair statePair : toBreak) {
            state = (BlockState)statePair.getValue();
            BlockPos target = (BlockPos)statePair.getKey();
            BlockEntity blockEntity = serverLevel.getBlockEntity(target);
            try {
                BlockBreakEventResult afterBreakEventResult = this.afterBreak((Level)serverLevel, player, state, target, blockEntity, Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)target, (BlockEntity)blockEntity, (Entity)player, (ItemStack)pickaxe), pickaxe, this.stateAfterBreak((Level)serverLevel, target, state));
                if (afterBreakEventResult.canceled()) continue;
                afterBreakEventResult.drops().stream().flatMap(this.itemConverter::convert).forEach(this.storage::addItem);
                int amount = resultMap.getOrDefault(target, BlockBreakEventResult.EMPTY).exp().orElse(afterBreakEventResult.exp().orElse(0));
                exp.addAndGet(amount);
            }
            catch (Exception e2) {
                QuarryPlus.LOGGER.warn(MARKER, "Error occurred while processing block {} at ({})", new Object[]{state.getBlock(), target.toShortString(), e2});
            }
        }
        for (Pair p : toBreak) {
            serverLevel.setBlock((BlockPos)p.getKey(), this.stateAfterBreak((Level)serverLevel, (BlockPos)p.getKey(), (BlockState)p.getRight()), 18);
        }
        if (exp.get() > 0) {
            this.getExpModule().ifPresent(e -> {
                this.useEnergy((long)AdvQuarryEntity.powerMap().expCollect() * 1000000000L, false, true, "expCollect");
                e.addExp(exp.get());
            });
        }
        this.setChanged();
        return WorkResult.SUCCESS;
    }

    @NotNull
    WorkResult cleanUpFluid(int x, int z) {
        assert (this.level != null);
        ServerLevel serverLevel = (ServerLevel)this.level;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        boolean flagRemoved = false;
        for (int y = this.getBlockPos().getY() - 1; y >= this.digMinY.getMinY((LevelReader)serverLevel); --y) {
            boolean blockIsReplaced;
            mutableBlockPos.set(x, y, z);
            BlockState state = serverLevel.getBlockState((BlockPos)mutableBlockPos);
            FluidState fluid = serverLevel.getFluidState((BlockPos)mutableBlockPos);
            boolean blockCondition = state.is((Block)PlatformAccess.getAccess().registerObjects().softBlock().get()) || state.is(Blocks.STONE) || state.is(Blocks.COBBLESTONE) || !fluid.isEmpty() && !fluid.isSource();
            boolean bl = blockIsReplaced = this.stateAfterBreak((Level)serverLevel, (BlockPos)mutableBlockPos, state) == state;
            if (!blockCondition || blockIsReplaced) continue;
            serverLevel.setBlock((BlockPos)mutableBlockPos, Blocks.AIR.defaultBlockState(), 3);
            flagRemoved = true;
        }
        return flagRemoved ? WorkResult.SUCCESS : WorkResult.SKIPPED;
    }

    protected final ServerPlayer getQuarryFakePlayer(ServerLevel level, BlockPos target) {
        return PlatformAccess.getAccess().mining().getQuarryFakePlayer(this, level, target);
    }

    protected BlockState stateAfterBreak(Level level, BlockPos pos, BlockState before) {
        return Blocks.AIR.defaultBlockState();
    }

    void removeFluidAt(@NotNull Level level, BlockPos pos, ServerPlayer player, BlockState newState) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof LiquidBlock) {
            FluidState f = level.getFluidState(pos);
            if (!f.isEmpty() && f.isSource()) {
                this.storage.addFluid(f.getType(), 81000L);
            }
            level.setBlock(pos, newState, 3);
        } else {
            Block f = state.getBlock();
            if (f instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)f;
                ItemStack picked = bucketPickup.pickupBlock((Player)player, (LevelAccessor)level, pos, state);
                this.storage.addBucketFluid(picked);
            } else {
                level.setBlock(pos, newState, 3);
            }
        }
    }

    void removeEdgeFluid(int x, int z, ServerLevel targetWorld, ServerPlayer player) {
        boolean flagMaxZ;
        assert (this.area != null);
        boolean flagMinX = x - 1 == this.area.minX();
        boolean flagMaxX = x + 1 == this.area.maxX();
        boolean flagMinZ = z - 1 == this.area.minZ();
        boolean bl = flagMaxZ = z + 1 == this.area.maxZ();
        if (flagMinX) {
            this.removeFluidAtXZ(this.area.minX(), z, targetWorld, player);
        }
        if (flagMaxX) {
            this.removeFluidAtXZ(this.area.maxX(), z, targetWorld, player);
        }
        if (flagMinZ) {
            this.removeFluidAtXZ(x, this.area.minZ(), targetWorld, player);
        }
        if (flagMaxZ) {
            this.removeFluidAtXZ(x, this.area.maxZ(), targetWorld, player);
        }
        if (flagMinX && flagMinZ) {
            this.removeFluidAtXZ(this.area.minX(), this.area.minZ(), targetWorld, player);
        }
        if (flagMinX && flagMaxZ) {
            this.removeFluidAtXZ(this.area.minX(), this.area.maxZ(), targetWorld, player);
        }
        if (flagMaxX && flagMinZ) {
            this.removeFluidAtXZ(this.area.maxX(), this.area.minZ(), targetWorld, player);
        }
        if (flagMaxX && flagMaxZ) {
            this.removeFluidAtXZ(this.area.maxX(), this.area.maxZ(), targetWorld, player);
        }
    }

    void removeFluidAtXZ(int x, int z, ServerLevel world, ServerPlayer player) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, 0, z);
        for (int y = this.getBlockPos().getY() - 1; y > this.digMinY.getMinY((LevelReader)world); --y) {
            pos.setY(y);
            FluidState fluidState = world.getFluidState((BlockPos)pos);
            if (fluidState.isEmpty()) continue;
            this.useEnergy((long)(AdvQuarryEntity.powerMap().breakBlockFluid() * 1.0E9), false, true, "removeFluid");
            this.removeFluidAt((Level)world, (BlockPos)pos, player, PlatformAccess.getAccess().registerObjects().frameBlock().get().getDammingState());
        }
    }

    protected final BlockBreakEventResult checkBreakEvent(Level level, ServerPlayer fakePlayer, BlockState state, BlockPos target, @Nullable BlockEntity blockEntity) {
        return PlatformAccess.getAccess().mining().checkBreakEvent(this, level, fakePlayer, state, target, blockEntity);
    }

    protected final BlockBreakEventResult afterBreak(Level level, ServerPlayer fakePlayer, BlockState state, BlockPos target, @Nullable BlockEntity blockEntity, List<ItemStack> drops, ItemStack pickaxe, BlockState newState) {
        return PlatformAccess.getAccess().mining().afterBreak(this, level, fakePlayer, state, target, blockEntity, drops, pickaxe, newState);
    }

    WorkResult breakBlockModuleOverride(ServerLevel level, BlockState state, BlockPos target, float hardness) {
        if (hardness < 0.0f && state.is(Blocks.BEDROCK) && this.shouldRemoveBedrock()) {
            int worldBottom = level.getMinBuildHeight();
            int targetY = target.getY();
            if (level.dimension().equals(Level.NETHER)) {
                int top;
                int n = top = PlatformAccess.config().removeBedrockOnNetherTop() ? level.getMaxBuildHeight() + 1 : 127;
                if (!(worldBottom < targetY && targetY < worldBottom + 5 || 122 < targetY && targetY < top)) {
                    return WorkResult.SKIPPED;
                }
            } else if (worldBottom >= targetY || targetY >= worldBottom + 5) {
                return WorkResult.SKIPPED;
            }
            HolderGetter.Provider lookup = level.registryAccess().asGetterLookup();
            long requiredEnergy = AdvQuarryEntity.powerMap().getBreakEnergy(hardness, this.enchantmentCache.getLevel(this.getEnchantments(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, lookup), 0, 0, true);
            this.useEnergy(requiredEnergy, false, true, "breakBlock");
            level.setBlock(target, this.stateAfterBreak((Level)level, target, state), 3);
            return WorkResult.SUCCESS;
        }
        if (state.is(Blocks.NETHER_PORTAL)) {
            level.removeBlock(target, false);
            return WorkResult.SUCCESS;
        }
        return WorkResult.SKIPPED;
    }

    @VisibleForTesting
    @NotNull
    public ItemEnchantments getEnchantments() {
        return (ItemEnchantments)this.components().getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
    }

    @VisibleForTesting
    public void setEnchantments(@NotNull ItemEnchantments enchantments) {
        this.setComponents(DataComponentMap.builder().addAll(this.components()).set(DataComponents.ENCHANTMENTS, (Object)enchantments).build());
    }

    static boolean moduleFilter(QuarryModule module) {
        return module != QuarryModule.Constant.PUMP;
    }

    static ItemConverter defaultItemConverter() {
        if (PlatformAccess.config().removeCommonMaterialsByChunkDestroyer()) {
            return ItemConverter.defaultInstance().concat(List.of(new ItemConverter.ChunkDestroyerConversion()));
        }
        return ItemConverter.defaultInstance();
    }

    protected boolean shouldRemoveMinecarts() {
        return PlatformAccess.config().removeMinecartWithChest();
    }
}

