/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.machine.marker.FlexibleMarkerEntity;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class FlexibleMarkerMessage
implements CustomPacketPayload,
OnReceiveWithLevel {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"flexible_marker_message");
    public static final CustomPacketPayload.Type<FlexibleMarkerMessage> TYPE = new CustomPacketPayload.Type(NAME);
    public static final StreamCodec<FriendlyByteBuf, FlexibleMarkerMessage> STREAM_CODEC = CustomPacketPayload.codec(FlexibleMarkerMessage::write, FlexibleMarkerMessage::new);
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final FlexibleMarkerEntity.Movable movable;
    private final int amount;

    public FlexibleMarkerMessage(BlockPos pos, ResourceKey<Level> dim, FlexibleMarkerEntity.Movable movable, int amount) {
        this.pos = pos;
        this.dim = dim;
        this.movable = movable;
        this.amount = amount;
    }

    public FlexibleMarkerMessage(FlexibleMarkerEntity marker, FlexibleMarkerEntity.Movable movable, int amount) {
        this(marker.getBlockPos(), (ResourceKey<Level>)Objects.requireNonNull(marker.getLevel()).dimension(), movable, amount);
    }

    FlexibleMarkerMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buffer.readResourceLocation());
        this.movable = (FlexibleMarkerEntity.Movable)buffer.readEnum(FlexibleMarkerEntity.Movable.class);
        this.amount = buffer.readInt();
    }

    void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos).writeResourceKey(this.dim);
        buffer.writeEnum((Enum)this.movable);
        buffer.writeInt(this.amount);
    }

    @Override
    public void onReceive(Level level, Player player) {
        if (!level.dimension().equals(this.dim)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof FlexibleMarkerEntity) {
            FlexibleMarkerEntity marker = (FlexibleMarkerEntity)blockEntity;
            if (marker.enabled) {
                marker.move(this.movable, this.amount);
                marker.syncToClient();
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

