/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.misc;

import com.mojang.serialization.MapCodec;
import com.yogpc.qp.InCreativeTabs;
import com.yogpc.qp.machine.misc.Direction26;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public final class SoftBlock
extends TransparentBlock
implements InCreativeTabs {
    public static final String NAME = "soft_block";
    private static final int CHAIN_MAX = 16383;
    public final ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"soft_block");
    public final BlockItem blockItem = new BlockItem((Block)this, new Item.Properties());
    private static final MapCodec<SoftBlock> CODEC = SoftBlock.simpleCodec(p -> new SoftBlock());
    private boolean breaking = false;

    public SoftBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.NONE).noOcclusion().noLootTable().isValidSpawn((state, world, pos, type) -> false).isSuffocating((state, world, pos) -> false).isRedstoneConductor((state, world, pos) -> false).isViewBlocking((state, world, pos) -> false));
    }

    protected MapCodec<SoftBlock> codec() {
        return CODEC;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.getBlock() != newState.getBlock()) {
            if (!this.breaking) {
                this.breaking = true;
                this.breakChain(world, pos);
                this.breaking = false;
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    private void breakChain(Level world, BlockPos first) {
        if (!world.isClientSide) {
            ArrayList<BlockPos> nextCheck = new ArrayList<BlockPos>();
            for (Direction26 dir : Direction26.DIRECTIONS) {
                BlockPos nPos = first.offset(dir.vec());
                BlockState nBlock = world.getBlockState(nPos);
                if (nBlock.getBlock() != this) continue;
                nextCheck.add(nPos);
            }
            if (!nextCheck.isEmpty()) {
                MinecraftServer server = Objects.requireNonNull(world.getServer());
                int tickOffset = world.getRandom().nextIntBetweenInclusive(8, 30);
                server.tell((Runnable)new TickTask(server.getTickCount() + tickOffset, (Runnable)new ChainBreakTask(world, nextCheck, 1, b -> {
                    this.breaking = b;
                }, new HashSet<BlockPos>(), Predicate.isEqual(this))));
            }
        }
    }

    private record ChainBreakTask(Level level, Collection<BlockPos> targets, int totalRemoved, BooleanConsumer consumer, HashSet<BlockPos> checked, Predicate<Block> continueChain) implements Runnable
    {
        @Override
        public void run() {
            HashSet<BlockPos> removed = new HashSet<BlockPos>();
            ArrayList<BlockPos> nextCheck = new ArrayList<BlockPos>(this.targets);
            while (!nextCheck.isEmpty() && removed.size() < 16383) {
                BlockPos[] copied = nextCheck.toArray(new BlockPos[0]);
                nextCheck.clear();
                for (BlockPos pos : copied) {
                    BlockState nBlock;
                    for (Direction26 dir : Direction26.DIRECTIONS) {
                        BlockState nBlock2;
                        BlockPos nPos = pos.offset(dir.vec());
                        if (!this.checked.add(nPos) || !this.continueChain.test((nBlock2 = this.level.getBlockState(nPos)).getBlock()) || !removed.add(nPos)) continue;
                        nextCheck.add(nPos);
                    }
                    if (!this.checked.add(pos) || !this.continueChain.test((nBlock = this.level.getBlockState(pos)).getBlock())) continue;
                    removed.add(pos);
                }
            }
            this.consumer.accept(true);
            removed.forEach(p -> this.level.removeBlock(p, false));
            this.consumer.accept(false);
            if (!nextCheck.isEmpty()) {
                MinecraftServer server = Objects.requireNonNull(this.level.getServer());
                int tickOffset = this.level.getRandom().nextIntBetweenInclusive(8, 30);
                server.tell((Runnable)new TickTask(server.getTickCount() + tickOffset, (Runnable)new ChainBreakTask(this.level, nextCheck, this.totalRemoved + removed.size(), this.consumer, this.checked, this.continueChain)));
            }
        }
    }
}

