/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.module;

import com.yogpc.qp.machine.QpItem;
import com.yogpc.qp.machine.module.QuarryModule;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.VisibleForTesting;

public final class ModuleInventory
extends SimpleContainer {
    static final Set<ResourceLocation> allowMultiModule = Set.of(ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"void_module"));
    private final Predicate<QuarryModule> staticFilter;
    private final Function<ModuleInventory, Set<QuarryModule>> holdings;
    private final Runnable onChanged;

    public ModuleInventory(int size, Predicate<QuarryModule> staticFilter, Function<ModuleInventory, Set<QuarryModule>> holdings, Runnable onChanged) {
        super(size);
        this.staticFilter = staticFilter;
        this.holdings = holdings;
        this.onChanged = onChanged;
    }

    @VisibleForTesting
    ModuleInventory(int size) {
        this(size, q -> true, m -> Set.copyOf(m.getModules()), () -> {});
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof QuarryModuleProvider.Item) {
            QuarryModuleProvider.Item provider = (QuarryModuleProvider.Item)item;
            if (ItemStack.isSameItem((ItemStack)this.getItem(index), (ItemStack)stack)) {
                return true;
            }
            QuarryModule toAdd = provider.getModule(stack);
            if (!this.staticFilter.test(toAdd)) {
                return false;
            }
            return this.holdings.apply(this).stream().map(QuarryModule::moduleId).filter(Predicate.not(allowMultiModule::contains)).filter(Predicate.isEqual(toAdd.moduleId())).findAny().isEmpty();
        }
        return false;
    }

    public void setChanged() {
        super.setChanged();
        this.onChanged.run();
    }

    public Set<QuarryModule> getModules() {
        return ModuleInventory.getModules(this.getItems().stream());
    }

    @VisibleForTesting
    static Set<QuarryModule> getModules(Stream<ItemStack> stream) {
        return stream.filter(s -> s.getItem() instanceof QuarryModuleProvider.Item).mapMulti(ModuleInventory::itemValidation).map(s -> ((QuarryModuleProvider.Item)s.getItem()).getModule((ItemStack)s)).collect(Collectors.toUnmodifiableSet());
    }

    static void itemValidation(ItemStack stack, Consumer<ItemStack> consumer) {
        QpItem item;
        Item item2 = stack.getItem();
        if (!(item2 instanceof QpItem) || (item = (QpItem)item2).isEnabled()) {
            consumer.accept(stack);
        }
    }
}

