/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import net.minecraft.resources.ResourceLocation;

public class TextureHelper {
    public static final ResourceLocation MOD_ICONS = ResourceLocation.fromNamespaceAndPath((String)"appleskin", (String)"textures/icons.png");
    public static final ResourceLocation HUNGER_OUTLINE_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"appleskin", (String)"tooltip_hunger_outline");
    public static final ResourceLocation FOOD_EMPTY_HUNGER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/food_empty_hunger");
    public static final ResourceLocation FOOD_HALF_HUNGER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/food_half_hunger");
    public static final ResourceLocation FOOD_FULL_HUNGER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/food_full_hunger");
    public static final ResourceLocation FOOD_EMPTY_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/food_empty");
    public static final ResourceLocation FOOD_HALF_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/food_half");
    public static final ResourceLocation FOOD_FULL_TEXTURE = ResourceLocation.withDefaultNamespace((String)"hud/food_full");
    public static final ResourceLocation HEART_CONTAINER = ResourceLocation.withDefaultNamespace((String)"hud/heart/container");
    public static final ResourceLocation HEART_HARDCORE_CONTAINER = ResourceLocation.withDefaultNamespace((String)"hud/heart/container_hardcore");
    public static final ResourceLocation HEART_FULL = ResourceLocation.withDefaultNamespace((String)"hud/heart/full");
    public static final ResourceLocation HEART_HARDCORE_FULL = ResourceLocation.withDefaultNamespace((String)"hud/heart/hardcore_full");
    public static final ResourceLocation HEART_HALF = ResourceLocation.withDefaultNamespace((String)"hud/heart/half");
    public static final ResourceLocation HEART_HARDCORE_HALF = ResourceLocation.withDefaultNamespace((String)"hud/heart/hardcore_half");

    public static ResourceLocation getFoodTexture(boolean isRotten, FoodType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (isRotten) {
                    yield FOOD_EMPTY_HUNGER_TEXTURE;
                }
                yield FOOD_EMPTY_TEXTURE;
            }
            case 1 -> {
                if (isRotten) {
                    yield FOOD_HALF_HUNGER_TEXTURE;
                }
                yield FOOD_HALF_TEXTURE;
            }
            case 2 -> isRotten ? FOOD_FULL_HUNGER_TEXTURE : FOOD_FULL_TEXTURE;
        };
    }

    public static ResourceLocation getHeartTexture(boolean hardcore, HeartType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (hardcore) {
                    yield HEART_HARDCORE_CONTAINER;
                }
                yield HEART_CONTAINER;
            }
            case 1 -> {
                if (hardcore) {
                    yield HEART_HARDCORE_FULL;
                }
                yield HEART_FULL;
            }
            case 2 -> hardcore ? HEART_HARDCORE_HALF : HEART_HALF;
        };
    }

    public static enum FoodType {
        EMPTY,
        HALF,
        FULL;

    }

    public static enum HeartType {
        CONTAINER,
        FULL,
        HALF;

    }
}

