/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.components.AbilityExtenderComponent;
import it.hurts.sskirillss.relics.components.LockComponent;
import it.hurts.sskirillss.relics.components.ResearchComponent;
import it.hurts.sskirillss.relics.components.StatComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public record AbilityComponent(Map<String, StatComponent> stats, ResearchComponent research, LockComponent lock, AbilityExtenderComponent extender, int points) {
    public static final AbilityComponent EMPTY = new AbilityComponent(Map.of(), ResearchComponent.EMPTY, LockComponent.EMPTY, AbilityExtenderComponent.EMPTY, 0);
    public static final Codec<AbilityComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, StatComponent.CODEC).fieldOf("stats").forGetter(AbilityComponent::stats), (App)ResearchComponent.CODEC.fieldOf("research").forGetter(AbilityComponent::research), (App)LockComponent.CODEC.fieldOf("lock").forGetter(AbilityComponent::lock), (App)AbilityExtenderComponent.CODEC.fieldOf("extender").forGetter(AbilityComponent::extender), (App)Codec.INT.fieldOf("points").forGetter(AbilityComponent::points)).apply((Applicative)instance, AbilityComponent::new));

    public static AbilityComponentBuilder builder() {
        return new AbilityComponentBuilder();
    }

    public AbilityComponentBuilder toBuilder() {
        AbilityComponentBuilder builder = new AbilityComponentBuilder().research(this.research).lock(this.lock).extender(this.extender).points(this.points);
        if (this.stats != null) {
            builder.stats(this.stats);
        }
        return builder;
    }

    public static class AbilityComponentBuilder {
        private ArrayList<String> stats$key;
        private ArrayList<StatComponent> stats$value;
        private ResearchComponent research;
        private LockComponent lock;
        private AbilityExtenderComponent extender;
        private int points;

        AbilityComponentBuilder() {
        }

        public AbilityComponentBuilder stat(String statKey, StatComponent statValue) {
            if (this.stats$key == null) {
                this.stats$key = new ArrayList();
                this.stats$value = new ArrayList();
            }
            this.stats$key.add(statKey);
            this.stats$value.add(statValue);
            return this;
        }

        public AbilityComponentBuilder stats(Map<? extends String, ? extends StatComponent> stats) {
            if (stats == null) {
                throw new NullPointerException("stats cannot be null");
            }
            if (this.stats$key == null) {
                this.stats$key = new ArrayList();
                this.stats$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends StatComponent> $lombokEntry : stats.entrySet()) {
                this.stats$key.add($lombokEntry.getKey());
                this.stats$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public AbilityComponentBuilder clearStats() {
            if (this.stats$key != null) {
                this.stats$key.clear();
                this.stats$value.clear();
            }
            return this;
        }

        public AbilityComponentBuilder research(ResearchComponent research) {
            this.research = research;
            return this;
        }

        public AbilityComponentBuilder lock(LockComponent lock) {
            this.lock = lock;
            return this;
        }

        public AbilityComponentBuilder extender(AbilityExtenderComponent extender) {
            this.extender = extender;
            return this;
        }

        public AbilityComponentBuilder points(int points) {
            this.points = points;
            return this;
        }

        public AbilityComponent build() {
            Map<String, StatComponent> stats;
            switch (this.stats$key == null ? 0 : this.stats$key.size()) {
                case 0: {
                    stats = Collections.emptyMap();
                    break;
                }
                case 1: {
                    stats = Collections.singletonMap(this.stats$key.get(0), this.stats$value.get(0));
                    break;
                }
                default: {
                    stats = new LinkedHashMap(this.stats$key.size() < 0x40000000 ? 1 + this.stats$key.size() + (this.stats$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.stats$key.size(); ++$i) {
                        stats.put(this.stats$key.get($i), this.stats$value.get($i));
                    }
                    stats = Collections.unmodifiableMap(stats);
                }
            }
            return new AbilityComponent(stats, this.research, this.lock, this.extender, this.points);
        }

        public String toString() {
            return "AbilityComponent.AbilityComponentBuilder(stats$key=" + String.valueOf(this.stats$key) + ", stats$value=" + String.valueOf(this.stats$value) + ", research=" + String.valueOf(this.research) + ", lock=" + String.valueOf(this.lock) + ", extender=" + String.valueOf(this.extender) + ", points=" + this.points + ")";
        }
    }
}

