/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.common.data;

import com.hollingsworth.arsnouveau.api.item.NBTComponent;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidScrollData
implements NBTComponent<FluidScrollData>,
TooltipProvider {
    public static final Codec<FluidScrollData> CODEC = FluidStack.CODEC.listOf().xmap(FluidScrollData::new, i -> i.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidScrollData> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidStack.STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)), i -> i.items, FluidScrollData::new);
    private final List<FluidStack> items;

    public FluidScrollData(List<FluidStack> items) {
        this.items = List.copyOf(items);
    }

    public FluidScrollData() {
        this(List.of());
    }

    public boolean containsStack(FluidStack stack) {
        return FluidScrollData.contains(this.items, stack);
    }

    public static boolean contains(List<FluidStack> list, FluidStack stack) {
        return list.stream().anyMatch(s -> FluidStack.isSameFluid((FluidStack)s, (FluidStack)stack));
    }

    public Iterable<FluidStack> getItems() {
        return this.items;
    }

    public Codec<FluidScrollData> getCodec() {
        return CODEC;
    }

    public Mutable mutable() {
        return new Mutable(this);
    }

    public void addToTooltip(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext pContext, @NotNull Consumer<Component> pTooltipAdder, @NotNull TooltipFlag pTooltipFlag) {
        for (FluidStack s : this.items) {
            pTooltipAdder.accept(s.getHoverName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidScrollData that = (FluidScrollData)o;
        for (FluidStack stack : this.items) {
            if (that.containsStack(stack)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.getItems());
    }

    public static class Mutable {
        private final List<FluidStack> list;

        public Mutable(FluidScrollData data) {
            this.list = data.items.stream().map(FluidStack::copy).collect(Collectors.toCollection(ArrayList::new));
        }

        public boolean add(FluidStack stack) {
            return this.list.add(stack.copy());
        }

        public boolean remove(FluidStack stack) {
            return this.list.remove(stack.copy());
        }

        public List<FluidStack> getItems() {
            return this.list;
        }

        public FluidScrollData toImmutable() {
            return new FluidScrollData(this.list);
        }

        public boolean writeWithFeedback(Player player, FluidStack stackToWrite) {
            if (stackToWrite.isEmpty()) {
                return false;
            }
            if (FluidScrollData.contains(this.list, stackToWrite)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.scribe.item_removed"));
                return this.remove(stackToWrite);
            }
            if (this.add(stackToWrite)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.scribe.item_added"));
                return true;
            }
            return false;
        }
    }
}

