/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.solar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.solar.SolarBlock;
import owmii.powah.item.Itms;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.util.Misc;

public class SolarTile
extends AbstractEnergyProvider<SolarBlock>
implements IInventoryHolder {
    public static final String CAN_SEE_SKY = "can_see_sky";
    public static final String HAS_LENS_OF_ENDER = "has_lens_of_ender";
    private boolean canSeeSky;
    private boolean hasLensOfEnder;

    public SolarTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.SOLAR_PANEL.get(), pos, state, variant);
        this.inv.add(1);
    }

    public SolarTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(CompoundTag compound, HolderLookup.Provider registries) {
        super.readSync(compound, registries);
        this.canSeeSky = compound.getBoolean(CAN_SEE_SKY);
        this.hasLensOfEnder = compound.getBoolean(HAS_LENS_OF_ENDER);
    }

    @Override
    public CompoundTag writeSync(CompoundTag compound, HolderLookup.Provider registries) {
        compound.putBoolean(CAN_SEE_SKY, this.canSeeSky);
        compound.putBoolean(HAS_LENS_OF_ENDER, this.hasLensOfEnder);
        return super.writeSync(compound, registries);
    }

    @Override
    protected int postTick(Level world) {
        boolean flag;
        if (this.isRemote()) {
            return -1;
        }
        boolean bl = flag = this.chargeItems(1) + this.extractFromSides(world) > 0L;
        if (this.checkRedstone()) {
            boolean canSeeSkyNow;
            if (!this.hasLensOfEnder && (long)this.ticks % 40L == 0L && this.canSeeSky != (canSeeSkyNow = Misc.canBlockSeeSky(world, this.worldPosition.above()))) {
                this.canSeeSky = canSeeSkyNow;
                this.sync();
            }
            if (!this.energy.isFull() && (this.canSeeSky || this.hasLensOfEnder) && world.dimensionType().hasSkyLight() && world.getSkyDarken() < 4) {
                this.energy.produce(this.getGeneration());
                flag = true;
            }
        }
        return flag ? 5 : -1;
    }

    @Override
    public void onRemoved(Level world, BlockState state, BlockState newState, boolean isMoving) {
        super.onRemoved(world, state, newState, isMoving);
        if (state.getBlock() != newState.getBlock() && this.hasLensOfEnder) {
            Block.popResource((Level)world, (BlockPos)this.worldPosition, (ItemStack)new ItemStack((ItemLike)Itms.LENS_OF_ENDER.get()));
        }
    }

    public boolean canSeeSky() {
        return this.canSeeSky;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean isEnergyPresent(@Nullable Direction side) {
        return Direction.DOWN.equals((Object)side);
    }

    public boolean hasLensOfEnder() {
        return this.hasLensOfEnder;
    }

    public void setHasLensOfEnder(boolean hasLensOfEnder) {
        this.hasLensOfEnder = hasLensOfEnder;
        this.sync();
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }
}

