/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.book;

import guideme.compiler.PageCompiler;
import guideme.compiler.TagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.document.flow.LytFlowParent;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.mdast.mdx.model.MdxJsxTextElement;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Item;
import owmii.powah.block.Tier;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.config.v2.types.GeneratorConfig;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractGeneratorBlock;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.item.EnergyItem;
import owmii.powah.lib.item.ItemBlock;
import owmii.powah.util.Util;

public class PowahTagCompiler
implements TagCompiler {
    public Set<String> getTagNames() {
        return Set.of("powah:EnergyCapacity", "powah:EnergyMaxIO", "powah:EnergyGeneration");
    }

    public void compileFlowContext(PageCompiler compiler, LytFlowParent parent, MdxJsxTextElement el) {
        Item item = MdxAttrs.getRequiredItem((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"id");
        if (item == null) {
            return;
        }
        switch (el.name()) {
            case "powah:EnergyCapacity": {
                long capacity = 0L;
                if (item instanceof EnergyItem) {
                    EnergyItem energyItem = (EnergyItem)item;
                    capacity = energyItem.getEnergyInfo().capacity();
                } else if (item instanceof EnergyBlockItem) {
                    EnergyBlockItem energyBlockItem = (EnergyBlockItem)item;
                    capacity = ((IEnergyConfig)((AbstractEnergyBlock)energyBlockItem.getBlock()).getConfig()).getCapacity(energyBlockItem.getVariant());
                }
                parent.appendComponent((FormattedText)Component.translatable((String)"info.lollipop.fe", (Object[])new Object[]{Util.addCommas(capacity)}));
                break;
            }
            case "powah:EnergyMaxIO": {
                long maxIo = 0L;
                if (item instanceof EnergyBlockItem) {
                    EnergyBlockItem energyBlockItem = (EnergyBlockItem)item;
                    maxIo = ((IEnergyConfig)((AbstractEnergyBlock)energyBlockItem.getBlock()).getConfig()).getTransfer(energyBlockItem.getVariant());
                } else if (item instanceof EnergyItem) {
                    EnergyItem energyItem = (EnergyItem)item;
                    maxIo = PowahTagCompiler.getEnergyItemTransfer(energyItem);
                }
                parent.appendComponent((FormattedText)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.addCommas(maxIo)}));
                break;
            }
            case "powah:EnergyGeneration": {
                ItemBlock blockItem;
                Object b;
                long generation = 0L;
                if (item instanceof ItemBlock && (b = (blockItem = (ItemBlock)item).getBlock()) instanceof AbstractGeneratorBlock) {
                    AbstractGeneratorBlock generatorBlock = (AbstractGeneratorBlock)b;
                    generation = ((GeneratorConfig)generatorBlock.getConfig()).getGeneration((Tier)generatorBlock.getVariant());
                }
                parent.appendComponent((FormattedText)Component.translatable((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.addCommas(generation)}));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + el.name());
            }
        }
    }

    private static <V extends Enum<V>, C extends IEnergyConfig<V>, I extends EnergyItem<V, C, I>> long getEnergyItemTransfer(EnergyItem<V, C, I> energyItem) {
        return energyItem.getConfig().getTransfer(energyItem.getVariant());
    }
}

