/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.rei;

import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import owmii.powah.compat.rei.ReactorFuelCategory;
import owmii.powah.recipe.ReactorFuel;

public class ReactorFuelDisplay
implements Display {
    private final ResourceLocation id;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> output;
    private final int fuelAmount;
    private final int temperature;

    public ReactorFuelDisplay(ResourceLocation id, ReactorFuel fuel) {
        this.id = id;
        ItemStack stack = ((Item)BuiltInRegistries.ITEM.get(id)).getDefaultInstance();
        this.inputs = List.of(EntryIngredients.of((ItemStack)stack));
        this.output = List.of();
        this.fuelAmount = fuel.fuelAmount();
        this.temperature = fuel.temperature();
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.of(this.id);
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<ReactorFuelDisplay> getCategoryIdentifier() {
        return ReactorFuelCategory.ID;
    }

    public int getFuelAmount() {
        return this.fuelAmount;
    }

    public int getTemperature() {
        return this.temperature;
    }
}

