/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.lib.logistics.inventory.AbstractContainer;
import owmii.powah.network.packet.InteractWithTankPacket;

public abstract class AbstractTileContainer<T extends AbstractTileEntity<?, ?>>
extends AbstractContainer {
    public final T te;

    public AbstractTileContainer(@Nullable MenuType<?> containerType, int id, Inventory inventory, FriendlyByteBuf buffer) {
        this(containerType, id, inventory, AbstractTileContainer.getInventory(inventory.player, buffer.readBlockPos()));
    }

    public AbstractTileContainer(@Nullable MenuType<?> type, int id, Inventory inventory, T te) {
        super(type, id, inventory);
        this.te = te;
        this.init(inventory, te);
        ((AbstractTileEntity)this.te).setContainerOpen(true);
    }

    @Override
    protected final void init(Inventory inventory) {
        super.init(inventory);
    }

    protected void init(Inventory inventory, T te) {
    }

    protected static <T extends AbstractTileEntity<?, ?>> T getInventory(Player player, BlockPos pos) {
        BlockEntity tile = player.level().getBlockEntity(pos);
        if (tile instanceof AbstractTileEntity) {
            return (T)((AbstractTileEntity)tile);
        }
        return (T)new AbstractTileEntity(BlockEntityType.SIGN, pos, Blocks.AIR.defaultBlockState());
    }

    public void removed(Player player) {
        super.removed(player);
        ((AbstractTileEntity)this.te).setContainerOpen(false);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            int size = ((AbstractTileEntity)this.te).getInventory().getSlots();
            if (index < size ? !this.moveItemStackTo(stack1, size, this.slots.size(), true) : !this.moveItemStackTo(stack1, 0, size, false)) {
                return ItemStack.EMPTY;
            }
            if (stack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
                slot.onTake(this.player, stack);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    public void interactWithTank(boolean drain) {
        FluidActionResult result;
        ItemStack carried;
        if (this.player.level().isClientSide()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new InteractWithTankPacket(this.containerId, drain), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if ((carried = this.getCarried()).isEmpty()) {
            return;
        }
        Tank tank = ((AbstractTileEntity)this.te).getTank();
        if (tank.getCapacity() == 0) {
            return;
        }
        if (drain) {
            result = FluidUtil.tryFillContainer((ItemStack)carried, (IFluidHandler)tank, (int)tank.getCapacity(), (Player)this.player, (boolean)true);
        } else {
            result = FluidUtil.tryEmptyContainer((ItemStack)carried, (IFluidHandler)tank, (int)tank.getCapacity(), (Player)this.player, (boolean)true);
            if (!result.isSuccess() && FluidUtil.getFluidContained((ItemStack)carried).isEmpty()) {
                result = FluidUtil.tryFillContainer((ItemStack)carried, (IFluidHandler)tank, (int)tank.getCapacity(), (Player)this.player, (boolean)true);
            }
        }
        if (result.isSuccess()) {
            this.setCarried(result.getResult());
        }
    }
}

