/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class MultiBlockFormedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(ServerPlayer playerEntity, RailcraftBlockEntity blockEntity) {
        this.trigger(playerEntity, criterionInstance -> criterionInstance.matches(blockEntity));
    }

    public static Criterion<?> formedMultiBlock(BlockEntityType<?> tileEntityType) {
        return MultiBlockFormedTrigger.formedMultiBlock(tileEntityType, Optional.empty());
    }

    public static Criterion<TriggerInstance> formedMultiBlock(BlockEntityType<?> tileEntityType, Optional<NbtPredicate> nbtPredicate) {
        return RailcraftCriteriaTriggers.MULTIBLOCK_FORM.createCriterion(new TriggerInstance(Optional.empty(), Optional.of(tileEntityType), nbtPredicate));
    }

    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<BlockEntityType<?>> type, Optional<NbtPredicate> nbt) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec().optionalFieldOf("type").forGetter(TriggerInstance::type), (App)NbtPredicate.CODEC.optionalFieldOf("nbt").forGetter(TriggerInstance::nbt)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(RailcraftBlockEntity blockEntity) {
            return this.type.map(type -> type.equals(blockEntity.getType())).orElse(true) != false && this.nbt.map(predicate -> {
                RegistryAccess registryAccess = blockEntity.level().registryAccess();
                return predicate.matches((Tag)blockEntity.saveWithoutMetadata((HolderLookup.Provider)registryAccess));
            }).orElse(true) != false;
        }
    }
}

