/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.charge;

import mods.railcraft.api.charge.ChargeStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.energy.EnergyStorage;

public class ChargeStorageBlockImpl
extends EnergyStorage
implements ChargeStorage {
    private final BlockPos pos;
    private final ChargeStorage.Spec batterySpec;
    private StateImpl stateImpl = StateImpl.RECHARGEABLE;
    private ChargeStorage.State state = ChargeStorage.State.RECHARGEABLE;
    private int chargeDrawnThisTick;

    public ChargeStorageBlockImpl(BlockPos pos, ChargeStorage.Spec batterySpec) {
        super(batterySpec.capacity());
        this.pos = pos;
        this.batterySpec = batterySpec;
        this.setState(batterySpec.initialState());
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.pos;
    }

    @Override
    public ChargeStorage.State getState() {
        return this.state;
    }

    @Override
    public void setState(ChargeStorage.State state) {
        this.state = state;
        this.stateImpl = StateImpl.valueOf(state.name());
    }

    public ChargeStorage.Spec getBatterySpec() {
        return this.batterySpec;
    }

    public int getEnergyStored() {
        return this.stateImpl.getEnergyStored(this);
    }

    @Override
    public float getEfficiency() {
        return this.batterySpec.efficiency();
    }

    @Override
    public int getMaxDraw() {
        return this.stateImpl.getMaxDraw(this);
    }

    public void tick() {
        this.chargeDrawnThisTick = 0;
    }

    public int getMaxEnergyStored() {
        return this.stateImpl.getMaxEnergyStored(this);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int drawn = this.stateImpl.extractEnergy(this, maxExtract, simulate);
        if (!simulate) {
            this.chargeDrawnThisTick += drawn;
        }
        return drawn;
    }

    private int superExtractEnergy(int maxExtract, boolean simulate) {
        return super.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getAvailableCharge() {
        return Mth.clamp((int)(this.getMaxDraw() - this.chargeDrawnThisTick), (int)0, (int)Mth.floor((float)((float)this.getEnergyStored() * this.getEfficiency())));
    }

    public int getInitialCharge() {
        return this.state == ChargeStorage.State.DISPOSABLE ? this.getMaxEnergyStored() : 0;
    }

    public String toString() {
        return String.format("%s@%s { energy: %d }", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.energy);
    }

    private static enum StateImpl {
        INFINITE{

            @Override
            public int getEnergyStored(ChargeStorageBlockImpl battery) {
                return battery.getMaxEnergyStored();
            }

            @Override
            public int extractEnergy(ChargeStorageBlockImpl battery, int request, boolean simulate) {
                return request;
            }
        }
        ,
        SOURCE,
        RECHARGEABLE,
        DISPOSABLE,
        DISABLED{

            @Override
            public int getEnergyStored(ChargeStorageBlockImpl battery) {
                return 0;
            }

            @Override
            public int getMaxEnergyStored(ChargeStorageBlockImpl battery) {
                return 0;
            }

            @Override
            public int getMaxDraw(ChargeStorageBlockImpl battery) {
                return 0;
            }

            @Override
            public int extractEnergy(ChargeStorageBlockImpl battery, int request, boolean simulate) {
                return 0;
            }
        };


        public int getEnergyStored(ChargeStorageBlockImpl battery) {
            return battery.energy;
        }

        public int getMaxEnergyStored(ChargeStorageBlockImpl battery) {
            return battery.getBatterySpec().capacity();
        }

        public int getMaxDraw(ChargeStorageBlockImpl battery) {
            return battery.getBatterySpec().maxDraw();
        }

        public int extractEnergy(ChargeStorageBlockImpl battery, int desiredAmount, boolean simulate) {
            return battery.superExtractEnergy(desiredAmount, simulate);
        }
    }
}

