/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import mods.railcraft.particle.FireSparkParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.phys.Vec3;

public class FireSparkParticle
extends TextureSheetParticle {
    private final Vec3 destination;
    private final double maxHorizontalDist;
    private final float lavaParticleScale;

    private FireSparkParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, FireSparkParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.destination = options.destination();
        this.maxHorizontalDist = this.getHorizontalDistSq(this.destination);
        this.calculateVector(this.maxHorizontalDist);
        this.scale(0.5f);
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.quadSize *= this.random.nextFloat() * 2.0f + 0.2f;
        this.lavaParticleScale = this.quadSize;
        this.setLifetime(2000);
        this.hasPhysics = false;
        this.pickSprite(sprites);
    }

    private double getHorizontalDistSq(Vec3 point) {
        double xDiff = this.x - point.x;
        double zDiff = this.z - point.z;
        return xDiff * xDiff + zDiff * zDiff;
    }

    private void calculateVector(double dist) {
        Vec3 vecParticle = new Vec3(this.x, this.y, this.z);
        Vec3 vel = this.destination.subtract(vecParticle);
        vel = vel.normalize();
        float velScale = 0.1f;
        this.xd = vel.x * (double)velScale;
        this.yd = vel.y * (double)velScale + 0.4 * (dist / this.maxHorizontalDist);
        this.zd = vel.z * (double)velScale;
    }

    protected int getLightColor(float partialTick) {
        int brightness = super.getLightColor(partialTick);
        int j = brightness >> 16 & 0xFF;
        return 0xF0 | j << 16;
    }

    public float getQuadSize(float scaleFactor) {
        float f6 = ((float)this.age + scaleFactor) / (float)this.lifetime;
        this.quadSize = this.lavaParticleScale * (1.0f - f6 * f6);
        return this.quadSize;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            double dist;
            float f = (float)this.age / (float)this.lifetime;
            if (this.level.random.nextFloat() > f) {
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
            if ((dist = this.destination.distanceToSqr(this.x, this.y, this.z)) <= 0.1) {
                this.remove();
            } else {
                this.calculateVector(this.getHorizontalDistSq(this.destination));
                this.move(this.xd, this.yd, this.zd);
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<FireSparkParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(FireSparkParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new FireSparkParticle(level, x, y, z, dx, dy, dz, options, this.sprites);
        }
    }
}

