/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util;

import mods.railcraft.client.util.CuboidModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidRenderer {
    public static CuboidModel getFluidModel(FluidStack fluid, float maxX, float maxY, float maxZ, FluidType type) {
        CuboidModel model = new CuboidModel();
        model.setAll(new CuboidModel.Face(model).setSprite(FluidRenderer.getFluidTexture(fluid, type)));
        model.setMinX(0.0f);
        model.setMinY(0.0f);
        model.setMinZ(0.0f);
        model.setMaxX(maxX);
        model.setMaxY(maxY);
        model.setMaxZ(maxZ);
        return model;
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluidStack, FluidType type) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = type == FluidType.STILL ? IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(fluidStack) : IClientFluidTypeExtensions.of((Fluid)fluid).getFlowingTexture(fluidStack);
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(spriteLocation);
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }
}

