/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.AbstractCookingRecipeBuilder;
import mods.railcraft.world.item.crafting.CokeOvenRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class CokeOvenRecipeBuilder
extends AbstractCookingRecipeBuilder {
    public static final int DEFAULT_COOKING_TIME = 400;
    private final int creosoteOutput;

    private CokeOvenRecipeBuilder(ItemLike result, int count, Ingredient ingredient, float experience, int cookingTime, int creosoteOutput) {
        super(result, count, ingredient, experience, cookingTime);
        this.creosoteOutput = creosoteOutput;
    }

    public static CokeOvenRecipeBuilder coking(ItemLike result, Ingredient ingredient, float experience, int creosoteOutput) {
        return CokeOvenRecipeBuilder.coking(result, ingredient, experience, 400, creosoteOutput);
    }

    public static CokeOvenRecipeBuilder coking(ItemLike result, Ingredient ingredient, float experience, int cookingTime, int creosoteOutput) {
        return CokeOvenRecipeBuilder.coking(result, 1, ingredient, experience, cookingTime, creosoteOutput);
    }

    public static CokeOvenRecipeBuilder coking(ItemLike result, int resultCount, Ingredient ingredient, float experience, int cookingTime, int creosoteOutput) {
        return new CokeOvenRecipeBuilder(result, resultCount, ingredient, experience, cookingTime, creosoteOutput);
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        String path = resourceLocation.getPath();
        ResourceLocation customResourceLocation = RailcraftConstants.rl("coke_oven/" + path);
        ResourceLocation advancementId = customResourceLocation.withPrefix("recipes/");
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)customResourceLocation)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)customResourceLocation)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        CokeOvenRecipe recipe = new CokeOvenRecipe(this.ingredient, new ItemStack((ItemLike)this.result, this.count), this.experience, this.cookingTime, this.creosoteOutput);
        recipeOutput.accept(customResourceLocation, (Recipe)recipe, builder.build(advancementId));
    }
}

