/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.patterns;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.RollingRecipeBuilder;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RollingRecipePattern {
    public static void line(RecipeOutput recipeOutput, Ingredient ingredient, ItemLike result, int count) {
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        RollingRecipePattern.line(recipeOutput, ingredient, result, count, name);
    }

    public static void line(RecipeOutput recipeOutput, Ingredient ingredient, ItemLike result, int count, String customName) {
        RollingRecipeBuilder.rolled(result, count).pattern(" a ").pattern(" a ").pattern(" a ").define(Character.valueOf('a'), ingredient).save(recipeOutput, RailcraftConstants.rl(customName));
    }

    public static void parallelLines(RecipeOutput recipeOutput, Ingredient ingred, ItemLike result, int count, String customName) {
        RollingRecipePattern.parallelLines(recipeOutput, ingred, ingred, result, count, customName);
    }

    public static void parallelLines(RecipeOutput recipeOutput, Ingredient ingred1, Ingredient ingred2, ItemLike result, int count, String customName) {
        RollingRecipeBuilder.rolled(result, count).pattern("a b").pattern("a b").pattern("a b").define(Character.valueOf('a'), ingred1).define(Character.valueOf('b'), ingred2).save(recipeOutput, RailcraftConstants.rl(customName));
    }

    public static void parallelThreeLines(RecipeOutput recipeOutput, Ingredient ingred1, Ingredient ingred2, Ingredient ingred3, ItemLike result, int count) {
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        RollingRecipePattern.parallelThreeLines(recipeOutput, ingred1, ingred2, ingred3, result, count, name);
    }

    public static void parallelThreeLines(RecipeOutput recipeOutput, Ingredient ingred1, Ingredient ingred2, Ingredient ingred3, ItemLike result, int count, String customName) {
        RollingRecipeBuilder.rolled(result, count).pattern("abc").pattern("abc").pattern("abc").define(Character.valueOf('a'), ingred1).define(Character.valueOf('b'), ingred2).define(Character.valueOf('c'), ingred3).save(recipeOutput, RailcraftConstants.rl(customName));
    }

    public static void diagonalLine(RecipeOutput recipeOutput, Ingredient materialTag, ItemLike result, int count, String customName) {
        RollingRecipeBuilder.rolled(result, count).pattern("  a").pattern(" a ").pattern("a  ").define(Character.valueOf('a'), materialTag).save(recipeOutput, RailcraftConstants.rl(customName));
    }

    public static void square2x2(RecipeOutput recipeOutput, Ingredient materialTag, ItemLike result, int count) {
        RollingRecipePattern.square2x2(recipeOutput, materialTag, result, count, "");
    }

    public static void square2x2(RecipeOutput recipeOutput, Ingredient materialTag, ItemLike result, int count, String postfix) {
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        RollingRecipeBuilder.rolled(result, count).pattern("aa").pattern("aa").define(Character.valueOf('a'), materialTag).save(recipeOutput, RailcraftConstants.rl(name + postfix));
    }

    public static void hForm(RecipeOutput recipeOutput, Ingredient materialTag, ItemLike result, int count) {
        RollingRecipeBuilder.rolled(result, count).pattern("a a").pattern("aaa").pattern("a a").define(Character.valueOf('a'), materialTag).save(recipeOutput);
    }
}

