/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.patchouli;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.steamboiler.FireboxBlock;
import mods.railcraft.world.level.block.steamboiler.SteamBoilerTankBlock;
import mods.railcraft.world.level.block.tank.IronTankGaugeBlock;
import mods.railcraft.world.level.block.tank.IronTankValveBlock;
import mods.railcraft.world.level.block.tank.IronTankWallBlock;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class Patchouli {
    public static void setup() {
        PatchouliAPI.IPatchouliAPI patchouliApi = PatchouliAPI.get();
        IStateMatcher crusherBlock = Patchouli.validBlock(patchouliApi, (Block)RailcraftBlocks.CRUSHER.get());
        IMultiblock crusher = patchouliApi.makeMultiblock((String[][])new String[][]{{"BB", "BB", "BB"}, {"BB", "0B", "BB"}}, new Object[]{Character.valueOf('B'), crusherBlock, Character.valueOf('0'), crusherBlock}).setSymmetrical(false);
        patchouliApi.registerMultiblock(RailcraftConstants.rl("crusher"), crusher);
        IStateMatcher cokeOvenBlock = Patchouli.validBlock(patchouliApi, (Block)RailcraftBlocks.COKE_OVEN_BRICKS.get());
        IMultiblock cokeOven = patchouliApi.makeMultiblock((String[][])new String[][]{{"BBB", "BBB", "BBB"}, {"BBB", "BAB", "BBB"}, {"BBB", "B0B", "BBB"}}, new Object[]{Character.valueOf('B'), cokeOvenBlock, Character.valueOf('0'), cokeOvenBlock, Character.valueOf('A'), patchouliApi.airMatcher()}).setSymmetrical(true);
        patchouliApi.registerMultiblock(RailcraftConstants.rl("coke_oven"), cokeOven);
        IStateMatcher blastFurnaceBlock = Patchouli.validBlock(patchouliApi, (Block)RailcraftBlocks.BLAST_FURNACE_BRICKS.get());
        IMultiblock blastFurnace = patchouliApi.makeMultiblock((String[][])new String[][]{{"BBB", "BBB", "BBB"}, {"BBB", "BAB", "BBB"}, {"BBB", "BAB", "BBB"}, {"BBB", "B0B", "BBB"}}, new Object[]{Character.valueOf('B'), blastFurnaceBlock, Character.valueOf('0'), blastFurnaceBlock, Character.valueOf('A'), patchouliApi.airMatcher()}).setSymmetrical(true);
        patchouliApi.registerMultiblock(RailcraftConstants.rl("blast_furnace"), blastFurnace);
        IStateMatcher steamTurbineBlock = Patchouli.validBlock(patchouliApi, (Block)RailcraftBlocks.STEAM_TURBINE.get());
        IMultiblock steamTurbine = patchouliApi.makeMultiblock((String[][])new String[][]{{"BB", "BB", "BB"}, {"BB", "0B", "BB"}}, new Object[]{Character.valueOf('B'), steamTurbineBlock, Character.valueOf('0'), steamTurbineBlock}).setSymmetrical(false);
        patchouliApi.registerMultiblock(RailcraftConstants.rl("steam_turbine"), steamTurbine);
        IStateMatcher waterTankBlock = Patchouli.validBlock(patchouliApi, (Block)RailcraftBlocks.WATER_TANK_SIDING.get());
        IMultiblock waterTank = patchouliApi.makeMultiblock((String[][])new String[][]{{"BB", "BB"}, {"BB", "0B"}}, new Object[]{Character.valueOf('B'), waterTankBlock, Character.valueOf('0'), waterTankBlock}).setSymmetrical(true);
        patchouliApi.registerMultiblock(RailcraftConstants.rl("water_tank"), waterTank);
        IStateMatcher steamOvenBlock = Patchouli.validBlock(patchouliApi, (Block)RailcraftBlocks.STEAM_OVEN.get());
        IMultiblock steamOven = patchouliApi.makeMultiblock((String[][])new String[][]{{"BB", "BB"}, {"BB", "0B"}}, new Object[]{Character.valueOf('B'), steamOvenBlock, Character.valueOf('0'), steamOvenBlock}).setSymmetrical(true);
        patchouliApi.registerMultiblock(RailcraftConstants.rl("steam_oven"), steamOven);
        IStateMatcher ironTankWallBlock = Patchouli.validTankWallBlock(patchouliApi, (IronTankWallBlock)((Object)RailcraftBlocks.IRON_TANK_WALL.variantFor(DyeColor.WHITE).get()));
        IStateMatcher ironTankGaugeBlock = Patchouli.validTankGaugeBlock(patchouliApi, (IronTankGaugeBlock)((Object)RailcraftBlocks.IRON_TANK_GAUGE.variantFor(DyeColor.WHITE).get()));
        IStateMatcher ironTankValveBlock = Patchouli.validTankValveBlock(patchouliApi, (IronTankValveBlock)((Object)RailcraftBlocks.IRON_TANK_VALVE.variantFor(DyeColor.WHITE).get()));
        IMultiblock tank = patchouliApi.makeMultiblock((String[][])new String[][]{{"BBBBB", "BBBBB", "BBVBB", "BBBBB", "BBBBB"}, {"BGGGB", "GAAAG", "GAAAG", "GAAAG", "BGGGB"}, {"BGGGB", "GAAAG", "GAAAG", "GAAAG", "BGGGB"}, {"BGGGB", "GAAAG", "GAAAG", "GAAAG", "BGGGB"}, {"BBBBB", "BBBBB", "BBVBB", "BBBBB", "BB0BB"}}, new Object[]{Character.valueOf('A'), patchouliApi.airMatcher(), Character.valueOf('B'), ironTankWallBlock, Character.valueOf('G'), ironTankGaugeBlock, Character.valueOf('V'), ironTankValveBlock, Character.valueOf('0'), ironTankWallBlock}).setSymmetrical(true);
        patchouliApi.registerMultiblock(RailcraftConstants.rl("iron_tank"), tank);
        IStateMatcher solidFueledFireboxBlock = Patchouli.validFireboxBlock(patchouliApi, (FireboxBlock)((Object)RailcraftBlocks.SOLID_FUELED_FIREBOX.get()));
        IStateMatcher boilerTankBlock = Patchouli.validSteamBoilerTankBlock(patchouliApi, (SteamBoilerTankBlock)((Object)RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK.get()));
        IMultiblock boiler = patchouliApi.makeMultiblock((String[][])new String[][]{{"TT", "TT"}, {"TT", "TT"}, {"TT", "TT"}, {"B0", "BB"}}, new Object[]{Character.valueOf('B'), solidFueledFireboxBlock, Character.valueOf('T'), boilerTankBlock, Character.valueOf('0'), solidFueledFireboxBlock}).setSymmetrical(true);
        patchouliApi.registerMultiblock(RailcraftConstants.rl("boiler"), boiler);
    }

    private static IStateMatcher validBlock(PatchouliAPI.IPatchouliAPI api, Block block) {
        return api.predicateMatcher(block, state -> state.is(block));
    }

    private static IStateMatcher validTankWallBlock(PatchouliAPI.IPatchouliAPI api, IronTankWallBlock block) {
        return api.predicateMatcher((Block)block, state -> state.is(RailcraftTags.Blocks.IRON_TANK_WALL));
    }

    private static IStateMatcher validTankGaugeBlock(PatchouliAPI.IPatchouliAPI api, IronTankGaugeBlock block) {
        return api.predicateMatcher((Block)block, state -> state.is(RailcraftTags.Blocks.IRON_TANK_GAUGE));
    }

    private static IStateMatcher validTankValveBlock(PatchouliAPI.IPatchouliAPI api, IronTankValveBlock block) {
        return api.predicateMatcher((Block)block, state -> state.is(RailcraftTags.Blocks.IRON_TANK_VALVE));
    }

    private static IStateMatcher validFireboxBlock(PatchouliAPI.IPatchouliAPI api, FireboxBlock block) {
        return api.predicateMatcher((Block)block, state -> state.is((Block)RailcraftBlocks.FLUID_FUELED_FIREBOX.get()) || state.is((Block)RailcraftBlocks.SOLID_FUELED_FIREBOX.get()));
    }

    private static IStateMatcher validSteamBoilerTankBlock(PatchouliAPI.IPatchouliAPI api, SteamBoilerTankBlock block) {
        return api.predicateMatcher((Block)block, state -> state.is((Block)RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK.get()) || state.is((Block)RailcraftBlocks.HIGH_PRESSURE_STEAM_BOILER_TANK.get()));
    }
}

