/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import mods.railcraft.Translations;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.FirestoneItemEntity;
import mods.railcraft.world.item.CrackedFirestoneItem;
import mods.railcraft.world.item.FirestoneItem;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class RefinedFirestoneItem
extends FirestoneItem {
    public static final int CHARGES = 5000;
    protected final int heat;
    protected final RandomSource random;

    protected RefinedFirestoneItem(int heat, boolean spawnsFire, Item.Properties properties) {
        super(spawnsFire, properties);
        this.heat = heat;
        this.random = RandomSource.create();
    }

    public RefinedFirestoneItem(boolean spawnsFire, Item.Properties properties) {
        this(250, spawnsFire, properties);
    }

    public static ItemStack getItemCharged() {
        return ((RefinedFirestoneItem)((Object)RailcraftItems.REFINED_FIRESTONE.get())).getDefaultInstance();
    }

    public static ItemStack getItemEmpty() {
        ItemStack itemStack = ((RefinedFirestoneItem)((Object)RailcraftItems.REFINED_FIRESTONE.get())).getDefaultInstance();
        itemStack.setDamageValue(4999);
        return itemStack;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack newStack;
        double damageLevel = (double)itemStack.getDamageValue() / (double)itemStack.getMaxDamage();
        if (this.random.nextDouble() < damageLevel * 1.0E-4) {
            newStack = CrackedFirestoneItem.getItemEmpty();
            if (itemStack.has(DataComponents.CUSTOM_NAME)) {
                newStack.set(DataComponents.CUSTOM_NAME, (Object)itemStack.getHoverName());
            }
        } else {
            newStack = itemStack.copy();
        }
        newStack.setCount(1);
        AtomicReference<ItemStack> res = new AtomicReference<ItemStack>(newStack);
        Player player = CommonHooks.getCraftingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            newStack.hurtAndBreak(1, serverPlayer.serverLevel(), serverPlayer, __ -> res.set(ItemStack.EMPTY));
        }
        return res.get();
    }

    public final int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return itemStack.getDamageValue() < itemStack.getMaxDamage() ? this.heat : 0;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> lines, TooltipFlag adv) {
        MutableComponent component = itemStack.getDamageValue() >= itemStack.getMaxDamage() - 5 ? Component.translatable((String)Translations.Tips.FIRESTONE_EMPTY) : Component.translatable((String)Translations.Tips.FIRESTONE_CHARGED);
        lines.add((Component)component.withStyle(ChatFormatting.GRAY));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        BlockState blockState = level.getBlockState(pos);
        RandomSource random = level.getRandom();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (stack.getDamageValue() == stack.getMaxDamage()) {
            return InteractionResult.PASS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.mayUseItemAt(pos, side, stack)) {
            BlockState newState;
            ItemStack cooked;
            List drops;
            if (!blockState.is(Blocks.STONE) && (drops = Block.getDrops((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos))).size() == 1 && !((ItemStack)drops.getFirst()).isEmpty() && ((ItemStack)drops.getFirst()).getItem() instanceof BlockItem && (cooked = this.cookedItem(level, (ItemStack)drops.getFirst())).getItem() instanceof BlockItem && (newState = ContainerTools.getBlockStateFromStack(cooked, level, pos)) != null) {
                level.setBlockAndUpdate(pos, newState);
                level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.AMBIENT, 1.0f, random.nextFloat() * 0.4f + 0.8f);
                stack.hurtAndBreak(1, serverLevel, serverPlayer, __ -> {});
                return InteractionResult.SUCCESS;
            }
            if (player.mayUseItemAt(pos = pos.relative(side), side, stack) && level.getBlockState(pos).isAir()) {
                level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.AMBIENT, 1.0f, random.nextFloat() * 0.4f + 0.8f);
                level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                stack.hurtAndBreak(1, serverLevel, serverPlayer, __ -> {});
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private ItemStack cookedItem(Level level, ItemStack ingredient) {
        return level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(ingredient), level).map(x -> ((SmeltingRecipe)x.value()).getResultItem((HolderLookup.Provider)level.registryAccess())).orElse(ItemStack.EMPTY);
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!livingEntity.fireImmune()) {
                livingEntity.igniteForSeconds(5.0f);
                itemStack.hurtAndBreak(1, serverLevel, (LivingEntity)player, item -> player.onEquippedItemBroken(item, LivingEntity.getSlotForHand((InteractionHand)hand)));
                level.playSound(null, livingEntity.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.AMBIENT, 1.0f, player.getRandom().nextFloat() * 0.4f + 0.8f);
                player.swing(hand);
                level.setBlockAndUpdate(livingEntity.blockPosition(), Blocks.FIRE.defaultBlockState());
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Override
    public FirestoneItemEntity createEntity(Level level, Entity entity, ItemStack itemStack) {
        FirestoneItemEntity firestone = super.createEntity(level, entity, itemStack);
        firestone.setRefined(true);
        return firestone;
    }
}

