/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.world.level.block.MultiblockBlock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SteamTurbineBlock
extends MultiblockBlock
implements ChargeBlock {
    public static final Property<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public static final Property<Boolean> ROTATED = BooleanProperty.create((String)"rotated");
    private static final MapCodec<SteamTurbineBlock> CODEC = SteamTurbineBlock.simpleCodec(SteamTurbineBlock::new);

    public SteamTurbineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)Type.NONE))).setValue(ROTATED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends MultiblockBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, ROTATED});
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SteamTurbineBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : SteamTurbineBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.STEAM_TURBINE.get()), SteamTurbineBlockEntity::serverTick);
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.BLOCK, 0.0f, new ChargeStorage.Spec(ChargeStorage.State.DISABLED, 225 * ((Double)RailcraftConfig.SERVER.turbinePowerMultiplier.get()).intValue(), 225 * ((Double)RailcraftConfig.SERVER.turbinePowerMultiplier.get()).intValue(), 1.0f));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        Charge.zapEffectProvider().throwSparks(state, level, pos, rand, 50);
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        super.tick(blockState, level, blockPos, random);
        this.registerNode(blockState, level, blockPos);
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState oldState, boolean moved) {
        super.onPlace(blockState, level, blockPos, oldState, moved);
        if (!blockState.is(oldState.getBlock())) {
            this.registerNode(blockState, (ServerLevel)level, blockPos);
        }
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean moved) {
        super.onRemove(blockState, level, blockPos, newState, moved);
        if (!blockState.is(newState.getBlock())) {
            this.deregisterNode((ServerLevel)level, blockPos);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return Charge.distribution.network((ServerLevel)level).access(pos).getComparatorOutput();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)Translations.Tips.MULTIBLOCK3X2X2).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.STEAM_TURBINE_DESC_1).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.STEAM_TURBINE_DESC_2).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.STEAM_TURBINE_DESC_3).withStyle(ChatFormatting.GRAY));
    }

    public static enum Type implements StringRepresentable
    {
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right"),
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        WINDOW("window"),
        NONE("none");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

