/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.level.block.detector.DetectorBlock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DetectorBlockEntity
extends RailcraftBlockEntity {
    private static final float SENSITIVITY = 0.2f;
    private int powerState;
    private int powerDelay;
    private int tick;

    protected DetectorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    protected int updateInterval() {
        return 0;
    }

    protected boolean shouldTest() {
        return true;
    }

    protected int testCarts(List<AbstractMinecart> minecarts) {
        return minecarts.isEmpty() ? 0 : 15;
    }

    private static List<AbstractMinecart> getCarts(Level level, BlockPos blockPos) {
        return EntitySearcher.findMinecarts().at(blockPos).upTo(0.2f).list(level);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, DetectorBlockEntity blockEntity) {
        ++blockEntity.tick;
        if (blockEntity.powerDelay > 0) {
            --blockEntity.powerDelay;
            return;
        }
        if (blockEntity.updateInterval() == 0 || blockEntity.tick % blockEntity.updateInterval() == 0) {
            int newPowerState;
            int n = newPowerState = blockEntity.shouldTest() ? blockEntity.testCarts(DetectorBlockEntity.getCarts(level, blockPos)) : 0;
            if (newPowerState != blockEntity.powerState) {
                boolean powered;
                blockEntity.powerState = newPowerState;
                boolean bl = powered = blockEntity.powerState > 0;
                if (powered) {
                    blockEntity.powerDelay = 10;
                }
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)DetectorBlock.POWERED, (Comparable)Boolean.valueOf(powered)));
                BlockPos offsetPos = blockPos.offset(((Direction)blockState.getValue((Property)DetectorBlock.FACING)).getNormal());
                level.updateNeighborsAt(offsetPos, blockState.getBlock());
            }
            blockEntity.tick = 0;
        }
    }

    public int getPowerState() {
        return this.powerState;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.powerState = tag.getInt("powerState");
        this.powerDelay = tag.getInt("powerDelay");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("powerState", this.powerState);
        tag.putInt("powerDelay", this.powerDelay);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeVarInt(this.powerState);
        out.writeVarInt(this.powerDelay);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.powerState = in.readVarInt();
        this.powerDelay = in.readVarInt();
    }
}

