/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.DetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrainDetectorBlockEntity
extends DetectorBlockEntity {
    private int trainSize = 5;

    public TrainDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.TRAIN_DETECTOR.get(), blockPos, blockState);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        if (minecarts.stream().mapToInt(cart -> RollingStock.getOrThrow(cart).train().size()).anyMatch(count -> count >= this.getTrainSize())) {
            return 15;
        }
        return 0;
    }

    @Override
    protected int updateInterval() {
        return 4;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.trainSize = tag.getInt("trainSize");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("trainSize", this.trainSize);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeVarInt(this.trainSize);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.trainSize = in.readVarInt();
    }

    public int getTrainSize() {
        return this.trainSize;
    }

    public void setTrainSize(int trainSize) {
        this.trainSize = trainSize;
    }
}

