/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.tank;

import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ValveFluidHandler
implements IFluidHandler {
    private final TankBlockEntity blockEntity;
    private final TankBlockEntity master;

    public ValveFluidHandler(TankBlockEntity blockEntity, TankBlockEntity master) {
        this.blockEntity = blockEntity;
        this.master = master;
    }

    private IFluidHandler getDelegate() {
        return this.master.getModule().getTank();
    }

    private boolean isFillable() {
        return this.blockEntity.getBlockPos().getY() - this.master.getBlockPos().getY() > 0;
    }

    private boolean isDrainable() {
        return this.blockEntity.getBlockPos().getY() - this.master.getBlockPos().getY() <= 1;
    }

    public int getTanks() {
        return this.getDelegate().getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getDelegate().getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.getDelegate().getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getDelegate().isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isFillable()) {
            return 0;
        }
        return this.getDelegate().fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isDrainable()) {
            return FluidStack.EMPTY;
        }
        return this.getDelegate().drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.isDrainable()) {
            return FluidStack.EMPTY;
        }
        return this.getDelegate().drain(maxDrain, action);
    }
}

