/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.manipulator;

import com.mojang.serialization.MapCodec;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.CartDispenserBlockEntity;
import mods.railcraft.world.level.block.manipulator.ManipulatorBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CartDispenserBlock
extends ManipulatorBlock<CartDispenserBlockEntity> {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final MapCodec<CartDispenserBlock> CODEC = CartDispenserBlock.simpleCodec(CartDispenserBlock::new);

    public CartDispenserBlock(BlockBehaviour.Properties properties) {
        super(CartDispenserBlockEntity.class, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected MapCodec<? extends ManipulatorBlock<CartDispenserBlockEntity>> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    @Override
    public Direction getFacing(BlockState blockState) {
        return (Direction)blockState.getValue((Property)FACING);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : CartDispenserBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.CART_DISPENSER.get()), CartDispenserBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CartDispenserBlockEntity(pos, state);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.hasNeighborSignal(pos);
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CartDispenserBlockEntity) {
            CartDispenserBlockEntity cartDispenserBlockEntity = (CartDispenserBlockEntity)blockEntity;
            cartDispenserBlockEntity.onNeighborChange();
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)Translations.Tips.CART_DISPENSER).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.HIT_CROWBAR_TO_ROTATE).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.PAIR_WITH_CONTROL_TRACK).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.APPLY_REDSTONE_TO_DISPENSE_CARTS).withStyle(ChatFormatting.RED));
    }
}

