/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.TrackTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AbandonedTrackBlock
extends TrackBlock {
    public static final BooleanProperty GRASS = BooleanProperty.create((String)"grass");

    public AbandonedTrackBlock(BlockBehaviour.Properties properties) {
        super((Supplier<? extends TrackType>)TrackTypes.ABANDONED, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue((Property)GRASS, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{GRASS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean grass = Direction.Plane.HORIZONTAL.stream().anyMatch(s -> context.getLevel().getBlockState(context.getClickedPos().relative(s)).is(Blocks.TALL_GRASS));
        return (BlockState)super.getStateForPlacement(context).setValue((Property)GRASS, (Comparable)Boolean.valueOf(grass));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)Translations.Tips.DANGER).append(CommonComponents.SPACE).append((Component)Component.translatable((String)Translations.Tips.DERAILMENT_RISK)).withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)Translations.Tips.ABANDONED_TRACK).withStyle(ChatFormatting.GRAY));
    }
}

