/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.api.gui.widget;

import com.mrbysco.neoauth.util.SessionUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AuthButtonWidget
extends ImageButton {
    @Nullable
    private final Screen screen;
    @Nullable
    private final MoveAction moveAction;
    private boolean didDrag = false;
    private SessionUtils.SessionStatus sessionStatus = SessionUtils.SessionStatus.UNKNOWN;
    public static final WidgetSprites BUTTON_TEXTURES = new WidgetSprites(ResourceLocation.parse((String)"widget/locked_button"), ResourceLocation.parse((String)"widget/locked_button_disabled"), ResourceLocation.parse((String)"widget/locked_button_highlighted"));
    public static final ResourceLocation SESSION_STATUS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"neo_auth", (String)"textures/gui/session_status.png");

    public AuthButtonWidget(int x, int y, Button.OnPress pressAction) {
        this(null, x, y, pressAction, null);
    }

    public AuthButtonWidget(int x, int y, Button.OnPress pressAction, @Nullable Component message) {
        this(null, x, y, pressAction, null, null, message);
    }

    public AuthButtonWidget(int x, int y, Button.OnPress pressAction, @Nullable Tooltip tooltip, @Nullable Component message) {
        this(null, x, y, pressAction, null, tooltip, message);
    }

    public AuthButtonWidget(@Nullable Screen screen, int x, int y, Button.OnPress pressAction, @Nullable MoveAction moveAction) {
        this(screen, x, y, pressAction, moveAction, (Component)Component.translatable((String)"gui.neo_auth.button.auth"));
    }

    public AuthButtonWidget(@Nullable Screen screen, int x, int y, Button.OnPress pressAction, @Nullable MoveAction moveAction, @Nullable Component message) {
        this(screen, x, y, pressAction, moveAction, null, message);
    }

    public AuthButtonWidget(@Nullable Screen screen, int x, int y, Button.OnPress pressAction, @Nullable MoveAction moveAction, @Nullable Tooltip tooltip, Component message) {
        super(x, y, 20, 20, BUTTON_TEXTURES, pressAction, message);
        this.screen = screen;
        this.moveAction = moveAction;
        this.setTooltip(tooltip);
        this.refreshSessionStatus();
    }

    public SessionUtils.SessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    public void refreshSessionStatus() {
        this.sessionStatus = SessionUtils.SessionStatus.UNKNOWN;
        SessionUtils.getStatus().thenAccept(status -> {
            this.sessionStatus = status;
        });
    }

    public void setSessionStatus(SessionUtils.SessionStatus sessionStatus) {
        this.sessionStatus = sessionStatus;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.moveAction != null) {
            return this.isValidClickButton(button) && this.clicked(mouseX, mouseY);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.moveAction == null) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        if (!this.isValidClickButton(button)) {
            return false;
        }
        if (this.didDrag) {
            this.moveAction.onMove((Button)this);
            this.didDrag = false;
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.moveAction != null) {
            this.didDrag = true;
            if (this.screen != null) {
                this.setPosition(Math.min(Math.max(0, (int)mouseX - this.width / 2), this.screen.width - this.width), Math.min(Math.max(0, (int)mouseY - this.height / 2), this.screen.height - this.height));
            } else {
                this.setPosition((int)mouseX - this.width / 2, (int)mouseY - this.height / 2);
            }
        }
        super.onDrag(mouseX, mouseY, deltaX, deltaY);
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderWidget(context, mouseX, mouseY, delta);
        context.blit(SESSION_STATUS_TEXTURE, this.getX() + this.width - 6, this.getY() - 1, (float)(switch (this.sessionStatus) {
            case SessionUtils.SessionStatus.VALID -> 0;
            case SessionUtils.SessionStatus.OFFLINE -> 8;
            default -> 16;
        }), 0.0f, 8, 8, 24, 8);
    }

    @FunctionalInterface
    public static interface MoveAction {
        public void onMove(Button var1);
    }
}

