/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.energy;

import com.google.gson.JsonObject;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.XNet;
import mcjty.xnet.apiimpl.energy.EnergyConnectedEntity;
import mcjty.xnet.apiimpl.energy.EnergyConnectorSettings;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.setup.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"textures/gui/guielements.png");
    public static final MapCodec<EnergyChannelSettings> CODEC = MapCodec.unit(EnergyChannelSettings::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, EnergyChannelSettings> STREAM_CODEC = StreamCodec.of((buf, settings) -> {}, buf -> new EnergyChannelSettings());
    private List<EnergyConnectedEntity> energyExtractors = null;
    private List<EnergyConnectedEntity> energyConsumers = null;
    private long maxConsume = 0L;

    public IChannelType getType() {
        return XNet.setup.energyChannelType;
    }

    public JsonObject writeToJson() {
        return new JsonObject();
    }

    public void readFromJson(JsonObject data) {
    }

    public void readFromNBT(CompoundTag tag) {
    }

    public void writeToNBT(CompoundTag tag) {
    }

    public int getColors() {
        return 0;
    }

    public void tick(int channel, IControllerContext context) {
        if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) {
            return;
        }
        this.updateCache(channel, context);
        Level world = context.getControllerWorld();
        long totalToDistribute = 0L;
        HashMap<BlockPos, Integer> alreadyHandled = new HashMap<BlockPos, Integer>();
        ArrayList<Pair> energyProducers = new ArrayList<Pair>();
        for (EnergyConnectedEntity extractor : this.energyExtractors) {
            int connectorEnergy;
            int tosend;
            int level;
            Integer count;
            ConnectorTileEntity connectorTE;
            EnergyConnectorSettings settings;
            BlockEntity te;
            BlockPos connectorPos = extractor.connectorPos();
            Direction side = extractor.sidedConsumer().side();
            if (!LevelTools.isLoaded((Level)world, (BlockPos)extractor.getBlockPos()) || !EnergyChannelSettings.isEnergyTE(te = extractor.getConnectedEntity(), side.getOpposite()) || !this.checkRedstone(settings = (EnergyConnectorSettings)((Object)extractor.settings()), connectorTE = extractor.getConnectorEntity(), context) || (count = settings.getMinmax()) != null && (level = EnergyChannelSettings.getEnergyLevel(te, side.getOpposite())) < count) continue;
            int rate = extractor.rate();
            connectorTE.setEnergyInputFrom(side, rate);
            if (!alreadyHandled.containsKey(connectorPos)) {
                alreadyHandled.put(connectorPos, connectorTE.getEnergy());
            }
            if ((tosend = Math.min(rate, connectorEnergy = ((Integer)alreadyHandled.get(connectorPos)).intValue())) <= 0) continue;
            alreadyHandled.put(connectorPos, connectorEnergy - tosend);
            energyProducers.add(Pair.of((Object)connectorTE, (Object)tosend));
            if ((totalToDistribute += (long)tosend) < this.maxConsume) continue;
            break;
        }
        if (totalToDistribute <= 0L) {
            return;
        }
        long actuallyConsumed = this.insertEnergy(context, totalToDistribute);
        if (actuallyConsumed <= 0L) {
            return;
        }
        for (Pair entry : energyProducers) {
            ConnectorTileEntity connectorTE = (ConnectorTileEntity)entry.getKey();
            int amount = (Integer)entry.getValue();
            long actuallySpent = Math.min((long)amount, actuallyConsumed);
            connectorTE.setEnergy((int)((long)connectorTE.getEnergy() - actuallySpent));
            if ((actuallyConsumed -= actuallySpent) > 0L) continue;
            break;
        }
    }

    private long insertEnergy(@Nonnull IControllerContext context, long energy) {
        long total = 0L;
        Level world = context.getControllerWorld();
        for (EnergyConnectedEntity consumer : this.energyConsumers) {
            int level;
            Integer count;
            BlockEntity te;
            EnergyConnectorSettings settings = (EnergyConnectorSettings)((Object)consumer.settings());
            if (!LevelTools.isLoaded((Level)world, (BlockPos)consumer.getBlockPos()) || !EnergyChannelSettings.isEnergyTE(te = consumer.getConnectedEntity(), settings.getFacing()) || !this.checkRedstone(settings, consumer.getConnectorEntity(), context) || (count = settings.getMinmax()) != null && (level = EnergyChannelSettings.getEnergyLevel(te, settings.getFacing())) >= count) continue;
            long totransfer = Math.min((long)consumer.rate(), energy);
            long e = EnergyTools.receiveEnergy((BlockEntity)te, (Direction)settings.getFacing(), (long)totransfer);
            total += e;
            if ((energy -= e) > 0L) continue;
            return total;
        }
        return total;
    }

    public static boolean isEnergyTE(@Nullable BlockEntity be, @Nonnull Direction side) {
        if (be == null) {
            return false;
        }
        return be.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), (Object)side) != null;
    }

    public static int getEnergyLevel(BlockEntity be, @Nonnull Direction side) {
        IEnergyStorage capability;
        if (be != null && (capability = (IEnergyStorage)be.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, be.getBlockPos(), (Object)side)) != null) {
            return capability.getEnergyStored();
        }
        return 0;
    }

    public void cleanCache() {
        this.energyExtractors = null;
        this.energyConsumers = null;
        this.maxConsume = 0L;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.energyExtractors == null) {
            EnergyConnectedEntity connectedBlock;
            EnergyConnectorSettings con;
            this.energyExtractors = new ArrayList<EnergyConnectedEntity>();
            this.energyConsumers = new ArrayList<EnergyConnectedEntity>();
            Map connectors = context.getConnectors(channel);
            Level world = context.getControllerWorld();
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedBlock = this.getConnectedBlockInfo(context, entry, world, con = (EnergyConnectorSettings)((Object)entry.getValue()));
                if (connectedBlock == null) continue;
                if (con.getEnergyMode() == InsExtMode.EXT) {
                    this.energyExtractors.add(connectedBlock);
                    continue;
                }
                this.energyConsumers.add(connectedBlock);
                this.maxConsume += (long)connectedBlock.rate();
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedBlock = this.getConnectedBlockInfo(context, entry, world, con = (EnergyConnectorSettings)((Object)entry.getValue()));
                if (connectedBlock == null || con.getEnergyMode() != InsExtMode.INS) continue;
                this.energyConsumers.add(connectedBlock);
                this.maxConsume += (long)connectedBlock.rate();
            }
            this.energyExtractors.sort((o1, o2) -> ((EnergyConnectorSettings)((Object)((Object)((Object)o2.settings())))).getPriority().compareTo(((EnergyConnectorSettings)((Object)((Object)((Object)o1.settings())))).getPriority()));
            this.energyConsumers.sort((o1, o2) -> ((EnergyConnectorSettings)((Object)((Object)((Object)o2.settings())))).getPriority().compareTo(((EnergyConnectorSettings)((Object)((Object)((Object)o1.settings())))).getPriority()));
        }
    }

    @Nullable
    private EnergyConnectedEntity getConnectedBlockInfo(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, @Nonnull Level world, @Nonnull EnergyConnectorSettings con) {
        BlockPos connectorPos = context.findConsumerPosition(entry.getKey().consumerId());
        if (connectorPos == null) {
            return null;
        }
        ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)world.getBlockEntity(connectorPos);
        if (connectorTileEntity == null) {
            return null;
        }
        BlockPos connectedBlockPos = connectorPos.relative(entry.getKey().side());
        BlockEntity connectedEntity = world.getBlockEntity(connectedBlockPos);
        if (connectedEntity == null) {
            return null;
        }
        Integer rate = EnergyChannelSettings.getRateOrMax(con, connectorPos, world);
        return new EnergyConnectedEntity(entry.getKey(), con, connectorPos, connectedBlockPos, connectedEntity, connectorTileEntity, rate);
    }

    private static Integer getRateOrMax(@Nonnull EnergyConnectorSettings con, @Nonnull BlockPos connectorPos, @Nonnull Level world) {
        Integer rate = con.getRate();
        if (rate == null) {
            boolean advanced = ConnectorBlock.isAdvancedConnector(world, connectorPos);
            rate = advanced ? (Integer)Config.maxRfRateAdvanced.get() : (Integer)Config.maxRfRateNormal.get();
        }
        return rate;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 11, 80, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
    }

    public void update(Map<String, Object> data) {
    }
}

