/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.enums;

import com.mojang.serialization.Codec;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.ComponentFactory;
import mcjty.xnet.utils.I18nUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum ChannelMode implements ITranslatableEnum<ChannelMode>,
StringRepresentable
{
    PRIORITY("xnet.enum.channelmode.priority"),
    ROUNDROBIN("xnet.enum.channelmode.roundrobin");

    public static final Codec<ChannelMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, ChannelMode> STREAM_CODEC;
    private final String i18n;

    private ChannelMode(String i18n) {
        this.i18n = i18n;
    }

    public String getI18n() {
        return ComponentFactory.translatable((String)this.i18n).getString();
    }

    public String[] getI18nSplitedTooltip() {
        return I18nUtils.getSplitedEnumTooltip(this.i18n);
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ChannelMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(ChannelMode.class);
    }
}

