/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism_kubejs.component;

import com.klikli_dev.occultism.crafting.recipe.result.RecipeResult;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ItemWrapper;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@Info(value="Various recipe result related helper methods")
public interface RecipeResultWrapper {
    @Info(value="Returns an RecipeResult of the input")
    public static RecipeResult of(RecipeResult in) {
        return in;
    }

    @Info(value="Returns an RecipeResult of the input")
    public static RecipeResult of(RecipeResult in, int count) {
        return in.copyWithCount(count);
    }

    public static RecipeResult wrap(Context cx, @Nullable Object o) {
        while (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.EMPTY || o == Items.AIR || o == Ingredient.EMPTY) {
            return RecipeResult.of((ItemStack)ItemStack.EMPTY);
        }
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            return RecipeResult.of((TagKey)ItemTags.create((ResourceLocation)tag.location()));
        }
        if (o instanceof CharSequence) {
            return RecipeResultWrapper.ofString(cx, o.toString());
        }
        return RecipeResult.of((ItemStack)ItemWrapper.wrap((Context)cx, (Object)o));
    }

    public static RecipeResult ofString(Context registries, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return RecipeResult.of((ItemStack)ItemStack.EMPTY);
        }
        if (s.equals("*")) {
            throw new UnsupportedOperationException("Wildcard recipe results are not supported");
        }
        try {
            return RecipeResultWrapper.read(registries, new StringReader(s));
        }
        catch (CommandSyntaxException e) {
            KubeJS.LOGGER.error("Failed to read recipe result from '" + s + "': " + String.valueOf((Object)e));
            return RecipeResult.of((ItemStack)ItemStack.EMPTY);
        }
    }

    public static RecipeResult read(Context cx, StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return RecipeResult.of((ItemStack)ItemStack.EMPTY);
        }
        return switch (reader.peek()) {
            case '-' -> {
                reader.skip();
                yield RecipeResult.of((ItemStack)ItemStack.EMPTY);
            }
            case '*' -> {
                reader.skip();
                throw new UnsupportedOperationException("Wildcard recipe results are not supported");
            }
            case '#' -> {
                reader.skip();
                yield RecipeResult.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.read((StringReader)reader)));
            }
            case '@' -> {
                reader.skip();
                throw new UnsupportedOperationException("Namespaced recipe results are not supported");
            }
            case '%' -> {
                reader.skip();
                throw new UnsupportedOperationException("Creative tab recipe results are not supported");
            }
            case '/' -> throw new UnsupportedOperationException("Regex recipe results are not supported");
            case '[' -> throw new UnsupportedOperationException("Compound recipe results are not supported");
            default -> {
                DataComponentPredicate components;
                char next;
                ResourceLocation itemId = ResourceLocation.read((StringReader)reader);
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                char v1 = next = reader.canRead() ? reader.peek() : (char)'\u0000';
                if ((next == '[' || next == '{') && (components = DataComponentWrapper.readPredicate((DynamicOps)RegistryAccessContainer.of((Context)cx).nbt(), (StringReader)reader)) != DataComponentPredicate.EMPTY) {
                    yield RecipeResult.of((ItemStack)new ItemStack((Holder)item.builtInRegistryHolder(), 1, components.asPatch()));
                }
                yield RecipeResult.of((ItemStack)new ItemStack((ItemLike)item));
            }
        };
    }
}

