/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageContainerNetworkNode
extends AbstractNetworkNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStorageContainerNetworkNode.class);
    protected final StateTrackedStorage[] storages;
    private long energyUsage;
    private final long energyUsagePerStorage;
    @Nullable
    private Provider provider;
    @Nullable
    private StateTrackedStorage.Listener listener;
    private int activeStorages;

    protected AbstractStorageContainerNetworkNode(long energyUsage, long energyUsagePerStorage, int size) {
        this.energyUsage = energyUsage;
        this.energyUsagePerStorage = energyUsagePerStorage;
        this.storages = new StateTrackedStorage[size];
    }

    public void setListener(StateTrackedStorage.Listener listener) {
        this.listener = listener;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
        ArrayList<StorageChange> changes = new ArrayList<StorageChange>();
        for (int i = 0; i < this.storages.length; ++i) {
            changes.addAll(this.initializeStorage(i));
        }
        if (this.activeStorages > 0) {
            changes.forEach(this::onStorageChange);
        }
        this.updateActiveStorageCount();
    }

    public void onStorageChanged(int index) {
        if (index < 0 || index >= this.storages.length) {
            LOGGER.warn("Invalid index {}", (Object)index);
            return;
        }
        this.initializeStorage(index).forEach(this::onStorageChange);
        this.updateActiveStorageCount();
    }

    protected void onStorageChange(StorageChange change) {
    }

    private Set<StorageChange> initializeStorage(int index) {
        HashSet<StorageChange> results = new HashSet<StorageChange>();
        if (this.storages[index] != null) {
            results.add(new StorageChange(true, this.storages[index]));
        }
        if (this.provider != null) {
            this.provider.resolve(index).ifPresentOrElse(resolved -> {
                StateTrackedStorage newStorage;
                this.storages[index] = newStorage = new StateTrackedStorage((Storage)resolved, this.listener);
                results.add(new StorageChange(false, newStorage));
            }, () -> {
                this.storages[index] = null;
            });
        }
        return results;
    }

    private void updateActiveStorageCount() {
        this.activeStorages = (int)Arrays.stream(this.storages).filter(Objects::nonNull).count();
    }

    public void setEnergyUsage(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    @Override
    public long getEnergyUsage() {
        return this.energyUsage + this.energyUsagePerStorage * (long)this.activeStorages;
    }

    public int getSize() {
        return this.storages.length;
    }

    public StorageState getState(int index) {
        StateTrackedStorage storage = this.storages[index];
        if (storage == null) {
            return StorageState.NONE;
        }
        if (!this.isActive()) {
            return StorageState.INACTIVE;
        }
        return storage.getState();
    }

    @FunctionalInterface
    public static interface Provider {
        public Optional<Storage> resolve(int var1);
    }

    protected record StorageChange(boolean removed, StateTrackedStorage storage) {
    }
}

