/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.storage;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.0")
public abstract class AbstractStorageContainerItem
extends Item
implements StorageContainerItem {
    protected final StorageContainerItemHelper helper;

    protected AbstractStorageContainerItem(Item.Properties properties, StorageContainerItemHelper helper) {
        super(properties);
        this.helper = helper;
    }

    @Override
    public Optional<SerializableStorage> resolve(StorageRepository storageRepository, ItemStack stack) {
        return this.helper.resolveStorage(storageRepository, stack);
    }

    @Override
    public Optional<StorageInfo> getInfo(StorageRepository storageRepository, ItemStack stack) {
        return this.helper.getInfo(storageRepository, stack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack primaryByproduct = this.createPrimaryDisassemblyByproduct(stack.getCount());
        ItemStack secondaryByproduct = this.createSecondaryDisassemblyByproduct(stack.getCount());
        return this.helper.tryDisassembly(level, player, stack, primaryByproduct, secondaryByproduct);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, level, entity, slot, selected);
        this.helper.transferStorageIfNecessary(stack, level, entity, this::createStorage);
        this.helper.loadStorageIfNecessary(stack, level, entity, this::createStorage);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getClientStorageRepository();
        this.helper.appendToTooltip(stack, storageRepository, tooltip, flag, this::formatAmount, this.getCapacity());
    }

    @Nullable
    protected abstract Long getCapacity();

    protected abstract String formatAmount(long var1);

    protected abstract SerializableStorage createStorage(StorageRepository var1);

    protected abstract ItemStack createPrimaryDisassemblyByproduct(int var1);

    @Nullable
    protected abstract ItemStack createSecondaryDisassemblyByproduct(int var1);
}

