/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.CraftingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.ProcessingPatternState;
import com.refinedmods.refinedstorage.common.autocrafting.SmithingTablePatternState;
import com.refinedmods.refinedstorage.common.autocrafting.StonecutterPatternState;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;

public class PatternResolver {
    PatternResolver() {
    }

    Optional<ResolvedCraftingPattern> getCraftingPattern(ItemStack stack, Level level, PatternState patternState) {
        CraftingPatternState craftingState = (CraftingPatternState)stack.get(DataComponents.INSTANCE.getCraftingPatternState());
        if (craftingState == null) {
            return Optional.empty();
        }
        return this.getCraftingPattern(level, patternState, craftingState);
    }

    private Optional<ResolvedCraftingPattern> getCraftingPattern(Level level, PatternState patternState, CraftingPatternState state) {
        RecipeMatrixContainer craftingMatrix = this.getFilledCraftingMatrix(state);
        CraftingInput.Positioned positionedCraftingInput = craftingMatrix.asPositionedCraftInput();
        CraftingInput craftingInput = positionedCraftingInput.input();
        return level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingInput, level).map(RecipeHolder::value).map(recipe -> this.toCraftingPattern(level, (CraftingRecipe)recipe, craftingInput, state, patternState));
    }

    private RecipeMatrixContainer getFilledCraftingMatrix(CraftingPatternState state) {
        CraftingInput.Positioned positionedInput = state.input();
        CraftingInput input = positionedInput.input();
        RecipeMatrixContainer craftingMatrix = new RecipeMatrixContainer(null, input.width(), input.height());
        for (int i = 0; i < input.size(); ++i) {
            craftingMatrix.setItem(i, input.getItem(i));
        }
        return craftingMatrix;
    }

    private ResolvedCraftingPattern toCraftingPattern(Level level, CraftingRecipe recipe, CraftingInput craftingInput, CraftingPatternState state, PatternState patternState) {
        List<List<ResourceKey>> inputs = this.getInputs(recipe, state);
        ResourceAmount output = this.getOutput(level, recipe, craftingInput);
        List<ResourceAmount> byproducts = this.getByproducts(recipe, craftingInput);
        return new ResolvedCraftingPattern(patternState.id(), inputs, output, byproducts);
    }

    private List<List<ResourceKey>> getInputs(CraftingRecipe recipe, CraftingPatternState state) {
        ArrayList<List<ResourceKey>> inputs = new ArrayList<List<ResourceKey>>();
        for (int i = 0; i < state.input().input().size(); ++i) {
            ItemStack input = state.input().input().getItem(i);
            if (input.isEmpty()) {
                inputs.add(Collections.emptyList());
                continue;
            }
            if (state.fuzzyMode()) {
                inputs.add(this.getFuzzyInput(recipe, state, i, input));
                continue;
            }
            inputs.add(List.of(ItemResource.ofItemStack(input)));
        }
        return inputs;
    }

    private List<ResourceKey> getFuzzyInput(CraftingRecipe recipe, CraftingPatternState state, int index, ItemStack input) {
        int ingredientIndex;
        int width = state.input().input().width();
        boolean mirror = this.isMirror((List<net.minecraft.world.item.crafting.Ingredient>)recipe.getIngredients(), state.input().input(), width);
        int col = index % width;
        int row = index / width;
        int n = ingredientIndex = mirror ? width - 1 - col + row * width : index;
        if (ingredientIndex >= 0 && ingredientIndex < recipe.getIngredients().size()) {
            ItemStack[] ingredients = ((net.minecraft.world.item.crafting.Ingredient)recipe.getIngredients().get(ingredientIndex)).getItems();
            return Arrays.stream(ingredients).map(item -> ItemResource.ofItemStack(item)).toList();
        }
        return List.of(ItemResource.ofItemStack(input));
    }

    private boolean isMirror(List<net.minecraft.world.item.crafting.Ingredient> ingredients, CraftingInput craftingInput, int width) {
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack input = craftingInput.getItem(i);
            if (input.isEmpty()) continue;
            int row = i / width;
            int col = i % width;
            int idx = row * width + col;
            if (idx < ingredients.size() && ingredients.get(idx).test(input)) {
                return false;
            }
            int mirroredIdx = row * width + (width - 1 - col);
            if (mirroredIdx >= ingredients.size() || !ingredients.get(mirroredIdx).test(input)) continue;
            return true;
        }
        return false;
    }

    private ResourceAmount getOutput(Level level, CraftingRecipe recipe, CraftingInput craftingInput) {
        ItemStack outputStack = recipe.assemble((RecipeInput)craftingInput, (HolderLookup.Provider)level.registryAccess());
        return new ResourceAmount(ItemResource.ofItemStack(outputStack), outputStack.getCount());
    }

    private List<ResourceAmount> getByproducts(CraftingRecipe recipe, CraftingInput craftingInput) {
        return recipe.getRemainingItems((RecipeInput)craftingInput).stream().filter(byproduct -> !byproduct.isEmpty()).map(byproduct -> new ResourceAmount(ItemResource.ofItemStack(byproduct), byproduct.getCount())).toList();
    }

    Optional<ResolvedProcessingPattern> getProcessingPattern(PatternState patternState, ItemStack stack) {
        ProcessingPatternState state = (ProcessingPatternState)stack.get(DataComponents.INSTANCE.getProcessingPatternState());
        if (state == null || state.getIngredients().isEmpty() || state.getFlatOutputs().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ResolvedProcessingPattern(patternState.id(), state.getIngredients(), state.getFlatOutputs()));
    }

    Optional<ResolvedStonecutterPattern> getStonecutterPattern(ItemStack stack, Level level, PatternState patternState) {
        StonecutterPatternState state = (StonecutterPatternState)stack.get(DataComponents.INSTANCE.getStonecutterPatternState());
        if (state == null) {
            return Optional.empty();
        }
        return this.getStonecutterPattern(level, patternState, state);
    }

    private Optional<ResolvedStonecutterPattern> getStonecutterPattern(Level level, PatternState patternState, StonecutterPatternState state) {
        SingleRecipeInput input = new SingleRecipeInput(state.input().toItemStack());
        ItemStack selectedOutput = state.selectedOutput().toItemStack();
        List recipes = level.getRecipeManager().getRecipesFor(RecipeType.STONECUTTING, (RecipeInput)input, level);
        for (RecipeHolder recipe : recipes) {
            ItemStack output = ((StonecutterRecipe)recipe.value()).assemble(input, (HolderLookup.Provider)level.registryAccess());
            if (!ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)selectedOutput)) continue;
            return Optional.of(new ResolvedStonecutterPattern(patternState.id(), state.input(), ItemResource.ofItemStack(output)));
        }
        return Optional.empty();
    }

    Optional<ResolvedSmithingTablePattern> getSmithingTablePattern(PatternState patternState, ItemStack stack, Level level) {
        SmithingTablePatternState state = (SmithingTablePatternState)stack.get(DataComponents.INSTANCE.getSmithingTablePatternState());
        if (state == null) {
            return Optional.empty();
        }
        return this.getSmithingTablePattern(level, patternState, state);
    }

    private Optional<ResolvedSmithingTablePattern> getSmithingTablePattern(Level level, PatternState patternState, SmithingTablePatternState state) {
        SmithingRecipeInput input = new SmithingRecipeInput(state.template().toItemStack(), state.base().toItemStack(), state.addition().toItemStack());
        return level.getRecipeManager().getRecipeFor(RecipeType.SMITHING, (RecipeInput)input, level).map(recipe -> new ResolvedSmithingTablePattern(patternState.id(), state.template(), state.base(), state.addition(), ItemResource.ofItemStack(((SmithingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess()))));
    }

    public record ResolvedCraftingPattern(List<List<ResourceKey>> inputs, ResourceAmount output, Pattern pattern) {
        ResolvedCraftingPattern(UUID id, List<List<ResourceKey>> inputs, ResourceAmount output, List<ResourceAmount> byproducts) {
            this(inputs, output, new Pattern(id, PatternLayout.internal(inputs.stream().filter(i -> !i.isEmpty()).map(i -> new Ingredient(1L, (List<ResourceKey>)i)).toList(), List.of(output), byproducts)));
        }
    }

    public record ResolvedProcessingPattern(Pattern pattern) {
        ResolvedProcessingPattern(UUID id, List<Ingredient> ingredients, List<ResourceAmount> outputs) {
            this(new Pattern(id, PatternLayout.external(ingredients, outputs)));
        }
    }

    public record ResolvedStonecutterPattern(ItemResource input, ItemResource output, Pattern pattern) {
        ResolvedStonecutterPattern(UUID id, ItemResource input, ItemResource output) {
            this(input, output, new Pattern(id, PatternLayout.internal(List.of(new Ingredient(1L, List.of(input))), List.of(new ResourceAmount(output, 1L)), List.of())));
        }
    }

    public record ResolvedSmithingTablePattern(ItemResource template, ItemResource base, ItemResource addition, ItemResource output, Pattern pattern) {
        ResolvedSmithingTablePattern(UUID id, ItemResource template, ItemResource base, ItemResource addition, ItemResource output) {
            this(template, base, addition, output, new Pattern(id, PatternLayout.internal(List.of(ResolvedSmithingTablePattern.single(template), ResolvedSmithingTablePattern.single(base), ResolvedSmithingTablePattern.single(addition)), List.of(new ResourceAmount(output, 1L)), List.of())));
        }

        private static Ingredient single(ResourceKey input) {
            return new Ingredient(1L, List.of(input));
        }
    }
}

