/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.common.networking.TransmittingIcon;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class WirelessTransmitterScreen
extends AbstractBaseScreen<WirelessTransmitterContainerMenu> {
    private static final MutableComponent INACTIVE = IdentifierUtil.createTranslation("gui", "wireless_transmitter.inactive");
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/wireless_transmitter.png");
    private final TransmittingIcon icon;

    public WirelessTransmitterScreen(WirelessTransmitterContainerMenu containerMenu, Inventory inventory, Component title) {
        super(containerMenu, inventory, title);
        this.inventoryLabelY = 43;
        this.imageWidth = 211;
        this.imageHeight = 137;
        this.icon = new TransmittingIcon(((WirelessTransmitterContainerMenu)this.getMenu()).isActive());
    }

    @Override
    protected void init() {
        super.init();
        this.addSideButton(new RedstoneModeSideButtonWidget(((WirelessTransmitterContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
    }

    protected void containerTick() {
        super.containerTick();
        this.icon.tick(((WirelessTransmitterContainerMenu)this.getMenu()).isActive());
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        this.icon.render(graphics, this.leftPos + 7, this.topPos + 22);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        if (!((WirelessTransmitterContainerMenu)this.getMenu()).isActive()) {
            graphics.drawString(this.font, (Component)INACTIVE, 7 + this.icon.getWidth() + 4, 25, 0x404040, false);
            return;
        }
        graphics.drawString(this.font, (Component)IdentifierUtil.createTranslation("gui", "wireless_transmitter.distance", ((WirelessTransmitterContainerMenu)this.getMenu()).getRange()), 7 + this.icon.getWidth() + 4, 25, 0x404040, false);
    }
}

