/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.storage.StoragePropertyTypes;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public abstract class AbstractStorageContainerMenu
extends AbstractResourceContainerMenu {
    protected AbstractStorageContainerMenu(MenuType<?> type, int syncId) {
        super(type, syncId);
        this.registerProperty(new ClientProperty<Integer>(StoragePropertyTypes.INSERT_PRIORITY, 0));
        this.registerProperty(new ClientProperty<Integer>(StoragePropertyTypes.EXTRACT_PRIORITY, 0));
        this.registerProperty(new ClientProperty<FilterMode>(PropertyTypes.FILTER_MODE, FilterMode.BLOCK));
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, false));
        this.registerProperty(new ClientProperty<AccessMode>(StoragePropertyTypes.ACCESS_MODE, AccessMode.INSERT_EXTRACT));
        this.registerProperty(new ClientProperty<Boolean>(StoragePropertyTypes.VOID_EXCESS, false));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
    }

    protected AbstractStorageContainerMenu(MenuType<?> type, int syncId, Player player, StorageConfigurationContainer configContainer) {
        super(type, syncId, player);
        this.registerProperty(new ServerProperty<Integer>(StoragePropertyTypes.INSERT_PRIORITY, configContainer::getInsertPriority, configContainer::setInsertPriority));
        this.registerProperty(new ServerProperty<Integer>(StoragePropertyTypes.EXTRACT_PRIORITY, configContainer::getExtractPriority, configContainer::setExtractPriority));
        this.registerProperty(new ServerProperty<FilterMode>(PropertyTypes.FILTER_MODE, configContainer::getFilterMode, configContainer::setFilterMode));
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, configContainer::isFuzzyMode, configContainer::setFuzzyMode));
        this.registerProperty(new ServerProperty<AccessMode>(StoragePropertyTypes.ACCESS_MODE, configContainer::getAccessMode, configContainer::setAccessMode));
        this.registerProperty(new ServerProperty<Boolean>(StoragePropertyTypes.VOID_EXCESS, configContainer::isVoidExcess, configContainer::setVoidExcess));
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, configContainer::getRedstoneMode, configContainer::setRedstoneMode));
    }

    boolean shouldDisplayFilterModeWarning() {
        return this.getProperty(PropertyTypes.FILTER_MODE).getValue() == FilterMode.ALLOW && this.areAllResourceSlotsEmpty();
    }

    boolean shouldDisplayVoidExcessModeWarning() {
        return Boolean.TRUE.equals(this.getProperty(StoragePropertyTypes.VOID_EXCESS).getValue()) && this.getProperty(PropertyTypes.FILTER_MODE).getValue() != FilterMode.ALLOW;
    }
}

