/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.common.storage.AbstractStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.AccessModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.storage.FilterModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.storage.StoragePropertyTypes;
import com.refinedmods.refinedstorage.common.storage.VoidExcessSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.widget.FuzzyModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.StoragePrioritySideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractStorageScreen<T extends AbstractStorageContainerMenu>
extends AbstractBaseScreen<T> {
    private static final Component ALLOW_FILTER_MODE_HELP = IdentifierUtil.createTranslation("gui", "storage.filter_mode.allow.help");
    private static final Component BLOCK_FILTER_MODE_HELP = IdentifierUtil.createTranslation("gui", "storage.filter_mode.block.help");
    private final Inventory playerInventory;
    @Nullable
    private FilterModeSideButtonWidget filterModeSideButtonWidget;
    @Nullable
    private VoidExcessSideButtonWidget voidExcessSideButtonWidget;

    protected AbstractStorageScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.playerInventory = inventory;
    }

    @Override
    protected void init() {
        super.init();
        this.addSideButton(new RedstoneModeSideButtonWidget(((AbstractStorageContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE), (Component)IdentifierUtil.createTranslation("gui", "storage.redstone_mode_help")));
        this.filterModeSideButtonWidget = new FilterModeSideButtonWidget(((AbstractStorageContainerMenu)this.getMenu()).getProperty(PropertyTypes.FILTER_MODE), ALLOW_FILTER_MODE_HELP, BLOCK_FILTER_MODE_HELP);
        this.addSideButton(this.filterModeSideButtonWidget);
        this.addSideButton(new FuzzyModeSideButtonWidget(((AbstractStorageContainerMenu)this.getMenu()).getProperty(PropertyTypes.FUZZY_MODE), () -> FuzzyModeSideButtonWidget.Type.STORAGE));
        this.addSideButton(new AccessModeSideButtonWidget(((AbstractStorageContainerMenu)this.getMenu()).getProperty(StoragePropertyTypes.ACCESS_MODE)));
        this.addSideButton(new StoragePrioritySideButtonWidget(((AbstractStorageContainerMenu)this.getMenu()).getProperty(StoragePropertyTypes.INSERT_PRIORITY), ((AbstractStorageContainerMenu)this.getMenu()).getProperty(StoragePropertyTypes.EXTRACT_PRIORITY), this.playerInventory, (Screen)this));
        this.voidExcessSideButtonWidget = new VoidExcessSideButtonWidget(((AbstractStorageContainerMenu)this.getMenu()).getProperty(StoragePropertyTypes.VOID_EXCESS));
        this.addSideButton(this.voidExcessSideButtonWidget);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.filterModeSideButtonWidget != null) {
            this.filterModeSideButtonWidget.setWarningVisible(((AbstractStorageContainerMenu)this.getMenu()).shouldDisplayFilterModeWarning());
        }
        if (this.voidExcessSideButtonWidget != null) {
            this.voidExcessSideButtonWidget.setWarningVisible(((AbstractStorageContainerMenu)this.getMenu()).shouldDisplayVoidExcessModeWarning());
        }
    }

    protected String formatAmount(long qty) {
        return IdentifierUtil.format(qty);
    }
}

